/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.column.Column;
import jakarta.nosql.column.ColumnCondition;
import java.util.Arrays;
import java.util.Objects;

abstract class BaseQueryBuilder {
    protected String name;
    protected boolean negate;
    protected boolean and;
    protected ColumnCondition condition;

    BaseQueryBuilder() {
    }

    protected <T> void eqImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.eq((Column)Column.of((String)this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void gtImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.gt((Column)Column.of((String)this.name, value));
        this.appendCondition(newCondition);
    }

    protected void likeImpl(String value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.like((Column)Column.of((String)this.name, (Object)value));
        this.appendCondition(newCondition);
    }

    protected <T> void ltImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.lt((Column)Column.of((String)this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void lteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.lte((Column)Column.of((String)this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void gteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.gte((Column)Column.of((String)this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void betweenImpl(T valueA, T valueB) {
        Objects.requireNonNull(valueA, "valueA is required");
        Objects.requireNonNull(valueB, "valueB is required");
        ColumnCondition newCondition = ColumnCondition.between((Column)Column.of((String)this.name, Arrays.asList(valueA, valueB)));
        this.appendCondition(newCondition);
    }

    protected <T> void inImpl(Iterable<T> values) {
        Objects.requireNonNull(values, "values is required");
        ColumnCondition newCondition = ColumnCondition.in((Column)Column.of((String)this.name, values));
        this.appendCondition(newCondition);
    }

    protected void appendCondition(ColumnCondition newCondition) {
        ColumnCondition columnCondition = this.getColumnCondition(newCondition);
        this.condition = Objects.nonNull(this.condition) ? (this.and ? this.condition.and(columnCondition) : this.condition.or(columnCondition)) : columnCondition;
        this.negate = false;
        this.name = null;
    }

    private ColumnCondition getColumnCondition(ColumnCondition newCondition) {
        if (this.negate) {
            return newCondition.negate();
        }
        return newCondition;
    }
}

