/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.column.Column;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnObserverParser;
import jakarta.nosql.query.JSONQueryValue;
import java.util.List;
import javax.json.JsonObject;
import org.eclipse.jnosql.communication.column.query.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.column.query.Conditions;
import org.eclipse.jnosql.communication.column.query.JsonObjects;

abstract class ConditionQueryParser {
    ConditionQueryParser() {
    }

    protected ColumnEntity getEntity(ConditionQuerySupplier query, String columnFamily, Params params, ColumnObserverParser observer) {
        ColumnEntity entity = ColumnEntity.of((String)columnFamily);
        if (query.useJSONCondition()) {
            JSONQueryValue jsonValue = query.getValue().orElseThrow(() -> new QueryException("It is an invalid state of either Update or Insert."));
            List<Column> columns = JsonObjects.getColumns((JsonObject)jsonValue.get());
            entity.addAll(columns);
            return entity;
        }
        query.getConditions().stream().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).map(ColumnCondition::getColumn).forEach(arg_0 -> ((ColumnEntity)entity).add(arg_0));
        return entity;
    }
}

