/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.column.Column;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.column.ColumnObserverParser;
import jakarta.nosql.query.Condition;
import jakarta.nosql.query.ConditionQueryValue;
import jakarta.nosql.query.Where;
import java.util.List;
import org.eclipse.jnosql.communication.column.query.Values;

final class Conditions {
    private Conditions() {
    }

    static ColumnCondition getCondition(Where where, Params params, ColumnObserverParser observer, String entity) {
        Condition condition = where.getCondition();
        return Conditions.getCondition(condition, params, observer, entity);
    }

    static ColumnCondition getCondition(Condition condition, Params parameters, ColumnObserverParser observer, String entity) {
        switch (condition.getOperator()) {
            case EQUALS: {
                return ColumnCondition.eq((Column)Column.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case GREATER_THAN: {
                return ColumnCondition.gt((Column)Column.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case GREATER_EQUALS_THAN: {
                return ColumnCondition.gte((Column)Column.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case LESSER_THAN: {
                return ColumnCondition.lt((Column)Column.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case LESSER_EQUALS_THAN: {
                return ColumnCondition.lte((Column)Column.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case IN: {
                return ColumnCondition.in((Column)Column.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case LIKE: {
                return ColumnCondition.like((Column)Column.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case BETWEEN: {
                return ColumnCondition.between((Column)Column.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case NOT: {
                return Conditions.getCondition((Condition)((List)((ConditionQueryValue)ConditionQueryValue.class.cast(condition.getValue())).get()).get(0), parameters, observer, entity).negate();
            }
            case OR: {
                return ColumnCondition.or((ColumnCondition[])((ColumnCondition[])((List)((ConditionQueryValue)ConditionQueryValue.class.cast(condition.getValue())).get()).stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(ColumnCondition[]::new)));
            }
            case AND: {
                return ColumnCondition.and((ColumnCondition[])((ColumnCondition[])((List)((ConditionQueryValue)ConditionQueryValue.class.cast(condition.getValue())).get()).stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(ColumnCondition[]::new)));
            }
        }
        throw new QueryException("There is not support the type: " + condition.getOperator());
    }

    private static String getName(Condition condition, ColumnObserverParser observer, String entity) {
        return observer.fireField(entity, condition.getName());
    }
}

