/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.column.ColumnDeleteQuery;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.column.ColumnPreparedStatement;
import jakarta.nosql.column.ColumnQuery;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

final class DefaultColumnPreparedStatement
implements ColumnPreparedStatement {
    private final ColumnEntity entity;
    private final ColumnQuery columnQuery;
    private final ColumnDeleteQuery columnDeleteQuery;
    private final PreparedStatementType type;
    private final Params params;
    private final String query;
    private final List<String> paramsLeft;
    private final Duration duration;
    private final ColumnManager manager;

    private DefaultColumnPreparedStatement(ColumnEntity entity, ColumnQuery columnQuery, ColumnDeleteQuery columnDeleteQuery, PreparedStatementType type, Params params, String query, List<String> paramsLeft, Duration duration, ColumnManager manager) {
        this.entity = entity;
        this.columnQuery = columnQuery;
        this.columnDeleteQuery = columnDeleteQuery;
        this.type = type;
        this.params = params;
        this.query = query;
        this.paramsLeft = paramsLeft;
        this.manager = manager;
        this.duration = duration;
    }

    public ColumnPreparedStatement bind(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.paramsLeft.remove(name);
        this.params.bind(name, value);
        return this;
    }

    public Stream<ColumnEntity> getResult() {
        if (!this.paramsLeft.isEmpty()) {
            throw new QueryException("Check all the parameters before execute the query, params left: " + this.paramsLeft);
        }
        switch (this.type) {
            case SELECT: {
                return this.manager.select(this.columnQuery);
            }
            case DELETE: {
                this.manager.delete(this.columnDeleteQuery);
                return Stream.empty();
            }
            case UPDATE: {
                return Stream.of(this.manager.update(this.entity));
            }
            case INSERT: {
                if (Objects.isNull(this.duration)) {
                    return Stream.of(this.manager.insert(this.entity));
                }
                return Stream.of(this.manager.insert(this.entity, this.duration));
            }
        }
        throw new UnsupportedOperationException("there is not support to operation type: " + this.type);
    }

    public Optional<ColumnEntity> getSingleResult() {
        Stream<ColumnEntity> entities = this.getResult();
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        ColumnEntity next = (ColumnEntity)iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(next);
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + this.query);
    }

    public String toString() {
        return this.query;
    }

    static ColumnPreparedStatement select(ColumnQuery columnQuery, Params params, String query, ColumnManager manager) {
        return new DefaultColumnPreparedStatement(null, columnQuery, null, PreparedStatementType.SELECT, params, query, params.getParametersNames(), null, manager);
    }

    static ColumnPreparedStatement delete(ColumnDeleteQuery columnDeleteQuery, Params params, String query, ColumnManager manager) {
        return new DefaultColumnPreparedStatement(null, null, columnDeleteQuery, PreparedStatementType.DELETE, params, query, params.getParametersNames(), null, manager);
    }

    static ColumnPreparedStatement insert(ColumnEntity entity, Params params, String query, Duration duration, ColumnManager manager) {
        return new DefaultColumnPreparedStatement(entity, null, null, PreparedStatementType.INSERT, params, query, params.getParametersNames(), duration, manager);
    }

    static ColumnPreparedStatement update(ColumnEntity entity, Params params, String query, ColumnManager manager) {
        return new DefaultColumnPreparedStatement(entity, null, null, PreparedStatementType.UPDATE, params, query, params.getParametersNames(), null, manager);
    }

    static enum PreparedStatementType {
        SELECT,
        DELETE,
        UPDATE,
        INSERT;

    }
}

