/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.Sort;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.column.ColumnQuery;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.column.DefaultColumnCondition;

class DefaultColumnQuery
implements ColumnQuery {
    private final long maxResults;
    private final long firstResult;
    private final String columnFamily;
    private final List<String> columns;
    private final List<Sort> sorts;
    private final ColumnCondition condition;

    DefaultColumnQuery(long maxResults, long firstResult, String columnFamily, List<String> columns, List<Sort> sorts, ColumnCondition condition) {
        this.maxResults = maxResults;
        this.firstResult = firstResult;
        this.columnFamily = columnFamily;
        this.columns = columns;
        this.sorts = sorts;
        this.condition = Optional.ofNullable(condition).map(DefaultColumnCondition::readOnly).orElse(null);
    }

    public long getLimit() {
        return this.maxResults;
    }

    public long getSkip() {
        return this.firstResult;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public Optional<ColumnCondition> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    public List<String> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public List<Sort> getSorts() {
        return Collections.unmodifiableList(this.sorts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnQuery)) {
            return false;
        }
        ColumnQuery that = (ColumnQuery)o;
        return this.maxResults == that.getLimit() && this.firstResult == that.getSkip() && Objects.equals(this.columnFamily, that.getColumnFamily()) && Objects.equals(this.columns, that.getColumns()) && Objects.equals(this.sorts, that.getSorts()) && Objects.equals(this.condition, that.getCondition().orElse(null));
    }

    public int hashCode() {
        return Objects.hash(this.maxResults, this.firstResult, this.columnFamily, this.columns, this.sorts, this.condition);
    }

    public String toString() {
        return "DefaultColumnQuery{maxResults=" + this.maxResults + ", firstResult=" + this.firstResult + ", columnFamily='" + this.columnFamily + "', columns=" + this.columns + ", sorts=" + this.sorts + ", condition=" + this.condition + "}";
    }
}

