/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.Sort;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.column.ColumnQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.column.query.DefaultColumnQuery;

class DefaultColumnQueryBuilder
implements ColumnQuery.ColumnQueryBuilder {
    private final List<String> columns = new ArrayList<String>();
    private final List<Sort> sorts = new ArrayList<Sort>();
    private String documentCollection;
    private ColumnCondition condition;
    private long skip;
    private long limit;

    DefaultColumnQueryBuilder() {
    }

    public ColumnQuery.ColumnQueryBuilder select(String column) {
        Objects.requireNonNull(column, "column is required");
        this.columns.add(column);
        return this;
    }

    public ColumnQuery.ColumnQueryBuilder select(String ... columns) {
        Consumer<String> validNull = d -> Objects.requireNonNull(d, "there is null column in the query");
        Consumer<String> consume = this.columns::add;
        Stream.of(columns).forEach(validNull.andThen(consume));
        return this;
    }

    public ColumnQuery.ColumnQueryBuilder sort(Sort sort) {
        Objects.requireNonNull(sort, "sort is required");
        this.sorts.add(sort);
        return this;
    }

    public ColumnQuery.ColumnQueryBuilder sort(Sort ... sorts) {
        Consumer<Sort> validNull = d -> Objects.requireNonNull(d, "there is null document in the query");
        Consumer<Sort> consume = this.sorts::add;
        Stream.of(sorts).forEach(validNull.andThen(consume));
        return this;
    }

    public ColumnQuery.ColumnQueryBuilder from(String documentCollection) {
        Objects.requireNonNull(documentCollection, "documentCollection is required");
        this.documentCollection = documentCollection;
        return this;
    }

    public ColumnQuery.ColumnQueryBuilder where(ColumnCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        this.condition = condition;
        return this;
    }

    public ColumnQuery.ColumnQueryBuilder skip(long skip) {
        if (skip < 0L) {
            throw new IllegalArgumentException("The skip should not be negative, skip: " + skip);
        }
        this.skip = skip;
        return this;
    }

    public ColumnQuery.ColumnQueryBuilder limit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("The limit should not be negative, limit: " + limit);
        }
        this.limit = limit;
        return this;
    }

    public ColumnQuery build() {
        if (Objects.isNull(this.documentCollection)) {
            throw new IllegalArgumentException("The document collection is mandatory to build");
        }
        return new DefaultColumnQuery(this.limit, this.skip, this.documentCollection, this.columns, this.sorts, this.condition);
    }

    public Stream<ColumnEntity> getResult(ColumnManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.select(this.build());
    }

    public Optional<ColumnEntity> getSingleResult(ColumnManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.singleResult(this.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultColumnQueryBuilder that = (DefaultColumnQueryBuilder)o;
        return this.skip == that.skip && this.limit == that.limit && Objects.equals(this.columns, that.columns) && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.documentCollection, that.documentCollection) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.sorts, this.documentCollection, this.condition, this.skip, this.limit);
    }

    public String toString() {
        return "DefaultColumnQueryBuilder{columns=" + this.columns + ", sorts=" + this.sorts + ", documentCollection='" + this.documentCollection + "', condition=" + this.condition + ", skip=" + this.skip + ", limit=" + this.limit + "}";
    }
}

