/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.QueryException;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.column.ColumnObserverParser;
import jakarta.nosql.column.ColumnPreparedStatement;
import jakarta.nosql.column.ColumnQueryParser;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.column.query.DeleteQueryParser;
import org.eclipse.jnosql.communication.column.query.InsertQueryParser;
import org.eclipse.jnosql.communication.column.query.SelectQueryParser;
import org.eclipse.jnosql.communication.column.query.UpdateQueryParser;

public final class DefaultColumnQueryParser
implements ColumnQueryParser {
    private final SelectQueryParser select = new SelectQueryParser();
    private final DeleteQueryParser delete = new DeleteQueryParser();
    private final InsertQueryParser insert = new InsertQueryParser();
    private final UpdateQueryParser update = new UpdateQueryParser();

    public Stream<ColumnEntity> query(String query, ColumnManager manager, ColumnObserverParser observer) {
        String command;
        this.validation(query, manager, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                return this.select.query(query, manager, observer);
            }
            case "delete": {
                return this.delete.query(query, manager, observer);
            }
            case "insert": {
                return this.insert.query(query, manager, observer);
            }
            case "update": {
                return this.update.query(query, manager, observer);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    public ColumnPreparedStatement prepare(String query, ColumnManager manager, ColumnObserverParser observer) {
        String command;
        this.validation(query, manager, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                return this.select.prepare(query, manager, observer);
            }
            case "delete": {
                return this.delete.prepare(query, manager, observer);
            }
            case "insert": {
                return this.insert.prepare(query, manager, observer);
            }
            case "update": {
                return this.update.prepare(query, manager, observer);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    private void validation(String query, ColumnManager manager, ColumnObserverParser observer) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(manager, "manager is required");
        Objects.requireNonNull(observer, "manager is observer");
        if (query.length() < 6) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }
}

