/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.Sort;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.column.ColumnDeleteQuery;
import jakarta.nosql.column.ColumnManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.column.query.DefaultColumnDeleteQuery;

class DefaultDeleteQueryBuilder
implements ColumnDeleteQuery.ColumnDeleteQueryBuilder {
    private final List<String> documents = new ArrayList<String>();
    private final List<Sort> sorts = new ArrayList<Sort>();
    private String documentCollection;
    private ColumnCondition condition;

    DefaultDeleteQueryBuilder() {
    }

    public ColumnDeleteQuery.ColumnDeleteQueryBuilder delete(String column) {
        Objects.requireNonNull(column, "column is required");
        this.documents.add(column);
        return this;
    }

    public ColumnDeleteQuery.ColumnDeleteQueryBuilder delete(String ... columns) {
        Consumer<String> validNull = c -> Objects.requireNonNull(c, "there is null column in the query");
        Consumer<String> consume = this.documents::add;
        Stream.of(columns).forEach(validNull.andThen(consume));
        return this;
    }

    public ColumnDeleteQuery.ColumnDeleteQueryBuilder from(String documentCollection) {
        Objects.requireNonNull(documentCollection, "documentCollection is required");
        this.documentCollection = documentCollection;
        return this;
    }

    public ColumnDeleteQuery.ColumnDeleteQueryBuilder where(ColumnCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        this.condition = condition;
        return this;
    }

    public ColumnDeleteQuery build() {
        if (Objects.isNull(this.documentCollection)) {
            throw new IllegalArgumentException("The document collection is mandatory to build");
        }
        return new DefaultColumnDeleteQuery(this.documentCollection, this.condition, this.documents);
    }

    public void delete(ColumnManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        manager.delete(this.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDeleteQueryBuilder that = (DefaultDeleteQueryBuilder)o;
        return Objects.equals(this.documents, that.documents) && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.documentCollection, that.documentCollection) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.documents, this.sorts, this.documentCollection, this.condition);
    }

    public String toString() {
        return "DefaultDeleteQueryBuilder{documents=" + this.documents + ", sorts=" + this.sorts + ", documentCollection='" + this.documentCollection + "', condition=" + this.condition + "}";
    }
}

