/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.Sort;
import jakarta.nosql.SortType;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.column.ColumnQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.column.query.BaseQueryBuilder;
import org.eclipse.jnosql.communication.column.query.DefaultColumnQuery;

class DefaultFluentColumnQueryBuilder
extends BaseQueryBuilder
implements ColumnQuery.ColumnSelect,
ColumnQuery.ColumnFrom,
ColumnQuery.ColumnLimit,
ColumnQuery.ColumnSkip,
ColumnQuery.ColumnOrder,
ColumnQuery.ColumnNameCondition,
ColumnQuery.ColumnNotCondition,
ColumnQuery.ColumnNameOrder,
ColumnQuery.ColumnWhere,
ColumnQuery.ColumnQueryBuild {
    private String columnFamily;
    private long skip;
    private long limit;
    private final List<Sort> sorts = new ArrayList<Sort>();
    private final List<String> columns;

    DefaultFluentColumnQueryBuilder(List<String> columns) {
        this.columns = columns;
    }

    public ColumnQuery.ColumnFrom from(String columnFamily) {
        Objects.requireNonNull(columnFamily, "columnFamily is required");
        this.columnFamily = columnFamily;
        return this;
    }

    public ColumnQuery.ColumnNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public ColumnQuery.ColumnNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    public ColumnQuery.ColumnNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    public ColumnQuery.ColumnSkip skip(long skip) {
        if (skip < 0L) {
            throw new IllegalArgumentException("The skip should not be negative, skip: " + skip);
        }
        this.skip = skip;
        return this;
    }

    public ColumnQuery.ColumnLimit limit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("The limit should not be negative, limit: " + limit);
        }
        this.limit = limit;
        return this;
    }

    public ColumnQuery.ColumnOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public ColumnQuery.ColumnNotCondition not() {
        this.negate = true;
        return this;
    }

    public <T> ColumnQuery.ColumnWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    public ColumnQuery.ColumnWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    public <T> ColumnQuery.ColumnWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    public <T> ColumnQuery.ColumnWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    public <T> ColumnQuery.ColumnWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    public <T> ColumnQuery.ColumnWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    public <T> ColumnQuery.ColumnWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    public <T> ColumnQuery.ColumnWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    public ColumnQuery.ColumnNameOrder asc() {
        this.sorts.add(Sort.of((String)this.name, (SortType)SortType.ASC));
        return this;
    }

    public ColumnQuery.ColumnNameOrder desc() {
        this.sorts.add(Sort.of((String)this.name, (SortType)SortType.DESC));
        return this;
    }

    public ColumnQuery build() {
        return new DefaultColumnQuery(this.limit, this.skip, this.columnFamily, this.columns, this.sorts, this.condition);
    }

    public Stream<ColumnEntity> getResult(ColumnManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.select(this.build());
    }

    public Optional<ColumnEntity> getSingleResult(ColumnManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.singleResult(this.build());
    }
}

