/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.column.ColumnDeleteQuery;
import jakarta.nosql.column.ColumnDeleteQueryParams;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.column.ColumnObserverParser;
import jakarta.nosql.column.ColumnPreparedStatement;
import jakarta.nosql.column.DeleteQueryConverter;
import jakarta.nosql.query.DeleteQuery;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.column.query.CacheQuery;
import org.eclipse.jnosql.communication.column.query.Conditions;
import org.eclipse.jnosql.communication.column.query.DefaultColumnDeleteQuery;
import org.eclipse.jnosql.communication.column.query.DefaultColumnDeleteQueryParams;
import org.eclipse.jnosql.communication.column.query.DefaultColumnPreparedStatement;

public final class DeleteQueryParser
implements DeleteQueryConverter {
    private final DeleteQuery.DeleteQueryProvider deleteQueryProvider = DeleteQuery.getProvider();
    private final CacheQuery<ColumnDeleteQuery> cache = new CacheQuery<ColumnDeleteQuery>(this::getQuery);

    Stream<ColumnEntity> query(String query, ColumnManager manager, ColumnObserverParser observer) {
        ColumnDeleteQuery columnDeleteQuery = this.cache.get(query, observer);
        manager.delete(columnDeleteQuery);
        return Stream.empty();
    }

    ColumnPreparedStatement prepare(String query, ColumnManager manager, ColumnObserverParser observer) {
        Params params = Params.newParams();
        ColumnDeleteQuery columnDeleteQuery = this.getQuery(query, params, observer);
        return DefaultColumnPreparedStatement.delete(columnDeleteQuery, params, query, manager);
    }

    public ColumnDeleteQueryParams apply(DeleteQuery deleteQuery, ColumnObserverParser columnObserverParser) {
        Objects.requireNonNull(deleteQuery, "deleteQuery is required");
        Objects.requireNonNull(columnObserverParser, "columnObserverParser is required");
        Params params = Params.newParams();
        ColumnDeleteQuery query = this.getQuery(params, columnObserverParser, deleteQuery);
        return new DefaultColumnDeleteQueryParams(query, params);
    }

    private ColumnDeleteQuery getQuery(String query, Params params, ColumnObserverParser observer) {
        DeleteQuery deleteQuery = (DeleteQuery)this.deleteQueryProvider.apply((Object)query);
        return this.getQuery(params, observer, deleteQuery);
    }

    private ColumnDeleteQuery getQuery(Params params, ColumnObserverParser observer, DeleteQuery deleteQuery) {
        String columnFamily = observer.fireEntity(deleteQuery.getEntity());
        List<String> columns = deleteQuery.getFields().stream().map(f -> observer.fireField(columnFamily, f)).collect(Collectors.toList());
        ColumnCondition condition = null;
        if (deleteQuery.getWhere().isPresent()) {
            condition = deleteQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).get();
        }
        return new DefaultColumnDeleteQuery(columnFamily, condition, columns);
    }

    private ColumnDeleteQuery getQuery(String query, ColumnObserverParser observer) {
        DeleteQuery deleteQuery = (DeleteQuery)this.deleteQueryProvider.apply((Object)query);
        String columnFamily = observer.fireEntity(deleteQuery.getEntity());
        List<String> columns = deleteQuery.getFields().stream().map(f -> observer.fireField(columnFamily, f)).collect(Collectors.toList());
        ColumnCondition condition = null;
        Params params = Params.newParams();
        if (deleteQuery.getWhere().isPresent()) {
            condition = deleteQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).get();
        }
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultColumnDeleteQuery(columnFamily, condition, columns);
    }
}

