/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.column.ColumnObserverParser;
import jakarta.nosql.column.ColumnPreparedStatement;
import jakarta.nosql.query.Condition;
import jakarta.nosql.query.InsertQuery;
import jakarta.nosql.query.JSONQueryValue;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.column.query.ConditionQueryParser;
import org.eclipse.jnosql.communication.column.query.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.column.query.DefaultColumnPreparedStatement;

final class InsertQueryParser
extends ConditionQueryParser {
    private final InsertQuery.InsertQueryProvider insertQueryProvider = InsertQuery.getProvider();

    InsertQueryParser() {
    }

    Stream<ColumnEntity> query(String query, ColumnManager manager, ColumnObserverParser observer) {
        InsertQuery insertQuery = (InsertQuery)this.insertQueryProvider.apply((Object)query);
        String columnFamily = insertQuery.getEntity();
        Params params = Params.newParams();
        ColumnEntity entity = this.getEntity(insertQuery, columnFamily, params, observer);
        Optional ttl = insertQuery.getTtl();
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        if (ttl.isPresent()) {
            return Stream.of(manager.insert(entity, (Duration)ttl.get()));
        }
        return Stream.of(manager.insert(entity));
    }

    ColumnPreparedStatement prepare(String query, ColumnManager manager, ColumnObserverParser observer) {
        InsertQuery insertQuery = (InsertQuery)this.insertQueryProvider.apply((Object)query);
        String columnFamily = observer.fireEntity(insertQuery.getEntity());
        Params params = Params.newParams();
        Optional ttl = insertQuery.getTtl();
        ColumnEntity entity = this.getEntity(insertQuery, columnFamily, params, observer);
        return DefaultColumnPreparedStatement.insert(entity, params, query, ttl.orElse(null), manager);
    }

    private ColumnEntity getEntity(InsertQuery insertQuery, String columnFamily, Params params, ColumnObserverParser observer) {
        return this.getEntity(new InsertQueryConditionSupplier(insertQuery), columnFamily, params, observer);
    }

    private static final class InsertQueryConditionSupplier
    implements ConditionQuerySupplier {
        private final InsertQuery query;

        private InsertQueryConditionSupplier(InsertQuery query) {
            this.query = query;
        }

        @Override
        public List<Condition> getConditions() {
            return this.query.getConditions();
        }

        @Override
        public Optional<JSONQueryValue> getValue() {
            return this.query.getValue();
        }
    }
}

