/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.Sort;
import jakarta.nosql.SortType;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.column.ColumnObserverParser;
import jakarta.nosql.column.ColumnPreparedStatement;
import jakarta.nosql.column.ColumnQuery;
import jakarta.nosql.column.ColumnQueryParams;
import jakarta.nosql.column.SelectQueryConverter;
import jakarta.nosql.query.SelectQuery;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.column.query.CacheQuery;
import org.eclipse.jnosql.communication.column.query.Conditions;
import org.eclipse.jnosql.communication.column.query.DefaultColumnPreparedStatement;
import org.eclipse.jnosql.communication.column.query.DefaultColumnQuery;
import org.eclipse.jnosql.communication.column.query.DefaultColumnQueryParams;

public final class SelectQueryParser
implements SelectQueryConverter {
    private final SelectQuery.SelectQueryProvider selectQueryProvider = SelectQuery.getProvider();
    private final CacheQuery<ColumnQuery> cache = new CacheQuery<ColumnQuery>(this::getColumnQuery);

    Stream<ColumnEntity> query(String query, ColumnManager manager, ColumnObserverParser observer) {
        ColumnQuery columnQuery = this.cache.get(query, observer);
        return manager.select(columnQuery);
    }

    ColumnPreparedStatement prepare(String query, ColumnManager manager, ColumnObserverParser observer) {
        Params params = Params.newParams();
        SelectQuery selectQuery = (SelectQuery)this.selectQueryProvider.apply((Object)query);
        ColumnQuery columnQuery = this.getColumnQuery(params, selectQuery, observer);
        return DefaultColumnPreparedStatement.select(columnQuery, params, query, manager);
    }

    public ColumnQueryParams apply(SelectQuery selectQuery, ColumnObserverParser observer) {
        Objects.requireNonNull(selectQuery, "selectQuery is required");
        Objects.requireNonNull(observer, "observer is required");
        Params params = Params.newParams();
        ColumnQuery columnQuery = this.getColumnQuery(params, selectQuery, observer);
        return new DefaultColumnQueryParams(columnQuery, params);
    }

    private ColumnQuery getColumnQuery(String query, ColumnObserverParser observer) {
        SelectQuery selectQuery = (SelectQuery)this.selectQueryProvider.apply((Object)query);
        String columnFamily = observer.fireEntity(selectQuery.getEntity());
        long limit = selectQuery.getLimit();
        long skip = selectQuery.getSkip();
        List<String> columns = selectQuery.getFields().stream().map(f -> observer.fireField(columnFamily, f)).collect(Collectors.toList());
        List<Sort> sorts = selectQuery.getOrderBy().stream().map(s -> this.toSort((Sort)s, observer, columnFamily)).collect(Collectors.toList());
        ColumnCondition condition = null;
        Params params = Params.newParams();
        if (selectQuery.getWhere().isPresent()) {
            condition = selectQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).get();
        }
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultColumnQuery(limit, skip, columnFamily, columns, sorts, condition);
    }

    private ColumnQuery getColumnQuery(Params params, SelectQuery selectQuery, ColumnObserverParser observer) {
        String columnFamily = observer.fireEntity(selectQuery.getEntity());
        long limit = selectQuery.getLimit();
        long skip = selectQuery.getSkip();
        List<String> columns = selectQuery.getFields().stream().map(f -> observer.fireField(columnFamily, f)).collect(Collectors.toList());
        List<Sort> sorts = selectQuery.getOrderBy().stream().map(s -> this.toSort((Sort)s, observer, columnFamily)).collect(Collectors.toList());
        ColumnCondition condition = null;
        if (selectQuery.getWhere().isPresent()) {
            condition = selectQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).get();
        }
        return new DefaultColumnQuery(limit, skip, columnFamily, columns, sorts, condition);
    }

    private Sort toSort(Sort sort, ColumnObserverParser observer, String entity) {
        return Sort.of((String)observer.fireField(entity, sort.getName()), (SortType)sort.getType());
    }
}

