/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.column.ColumnEntity;
import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.column.ColumnObserverParser;
import jakarta.nosql.column.ColumnPreparedStatement;
import jakarta.nosql.query.Condition;
import jakarta.nosql.query.JSONQueryValue;
import jakarta.nosql.query.UpdateQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.column.query.ConditionQueryParser;
import org.eclipse.jnosql.communication.column.query.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.column.query.DefaultColumnPreparedStatement;

final class UpdateQueryParser
extends ConditionQueryParser {
    private final UpdateQuery.UpdateQueryProvider updateQueryProvider = UpdateQuery.getProvider();

    UpdateQueryParser() {
    }

    Stream<ColumnEntity> query(String query, ColumnManager manager, ColumnObserverParser observer) {
        UpdateQuery updateQuery = (UpdateQuery)this.updateQueryProvider.apply((Object)query);
        Params params = Params.newParams();
        ColumnEntity entity = this.getEntity(params, updateQuery, observer);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return Stream.of(manager.update(entity));
    }

    ColumnPreparedStatement prepare(String query, ColumnManager manager, ColumnObserverParser observer) {
        Params params = Params.newParams();
        UpdateQuery updateQuery = (UpdateQuery)this.updateQueryProvider.apply((Object)query);
        ColumnEntity entity = this.getEntity(params, updateQuery, observer);
        return DefaultColumnPreparedStatement.update(entity, params, query, manager);
    }

    private ColumnEntity getEntity(Params params, UpdateQuery updateQuery, ColumnObserverParser observer) {
        String columnFamily = observer.fireEntity(updateQuery.getEntity());
        return this.getEntity(new UpdateQueryConditionSupplier(updateQuery), columnFamily, params, observer);
    }

    private static final class UpdateQueryConditionSupplier
    implements ConditionQuerySupplier {
        private final UpdateQuery query;

        private UpdateQueryConditionSupplier(UpdateQuery query) {
            this.query = query;
        }

        @Override
        public List<Condition> getConditions() {
            return this.query.getConditions();
        }

        @Override
        public Optional<JSONQueryValue> getValue() {
            return this.query.getValue();
        }
    }
}

