/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.column.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.Value;
import jakarta.nosql.query.ArrayQueryValue;
import jakarta.nosql.query.Function;
import jakarta.nosql.query.FunctionQueryValue;
import jakarta.nosql.query.JSONQueryValue;
import jakarta.nosql.query.ParamQueryValue;
import jakarta.nosql.query.QueryValue;
import jakarta.nosql.query.ValueType;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonObject;
import org.eclipse.jnosql.communication.column.query.JsonObjects;

final class Values {
    private Values() {
    }

    static Object get(QueryValue<?> value, Params parameters) {
        ValueType type = value.getType();
        switch (type) {
            case NUMBER: 
            case STRING: {
                return value.get();
            }
            case PARAMETER: {
                return parameters.add((String)((ParamQueryValue)ParamQueryValue.class.cast(value)).get());
            }
            case ARRAY: {
                return Stream.of((QueryValue[])((ArrayQueryValue)ArrayQueryValue.class.cast(value)).get()).map(v -> Values.get(v, parameters)).collect(Collectors.toList());
            }
            case FUNCTION: {
                Function function = (Function)((FunctionQueryValue)FunctionQueryValue.class.cast(value)).get();
                String name = function.getName();
                Object[] params = function.getParams();
                if ("convert".equals(name)) {
                    return Value.of((Object)Values.get((QueryValue)QueryValue.class.cast(params[0]), parameters)).get((Class)params[1]);
                }
                String message = String.format("There is not support to the function: %s with parameters %s", name, Arrays.toString(params));
                throw new QueryException(message);
            }
            case JSON: {
                return JsonObjects.getColumns((JsonObject)((JSONQueryValue)JSONQueryValue.class.cast(value)).get());
            }
        }
        throw new QueryException("There is not support to the value: " + type);
    }
}

