/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import jakarta.nosql.TypeSupplier;
import jakarta.nosql.Value;
import jakarta.nosql.document.Document;
import java.util.Objects;
import org.eclipse.jnosql.communication.Entry;

final class DefaultDocument
implements Document,
Entry {
    private final String name;
    private final Value value;

    DefaultDocument(String name, Value value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Value getValue() {
        return this.value;
    }

    public <T> T get(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        return (T)this.value.get(type);
    }

    public <T> T get(TypeSupplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier is required");
        return (T)this.value.get(supplier);
    }

    public Object get() {
        return this.value.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultDocument)) {
            return false;
        }
        Document that = (Document)o;
        return Objects.equals(this.name, that.getName()) && Objects.equals(this.value, that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return "Document{name='" + this.name + "', value=" + this.value + "}";
    }
}

