/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import jakarta.nosql.Condition;
import jakarta.nosql.TypeReference;
import jakarta.nosql.TypeSupplier;
import jakarta.nosql.Value;
import jakarta.nosql.document.Document;
import jakarta.nosql.document.DocumentCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;

public final class DefaultDocumentCondition
implements DocumentCondition {
    private final Document document;
    private final Condition condition;
    private final boolean readOnly;

    private DefaultDocumentCondition(Document document, Condition condition) {
        this.document = document;
        this.condition = condition;
        this.readOnly = false;
    }

    private DefaultDocumentCondition(Document document, Condition condition, boolean readOnly) {
        this.document = document;
        this.condition = condition;
        this.readOnly = readOnly;
    }

    public static DefaultDocumentCondition readOnly(DocumentCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        return new DefaultDocumentCondition(condition.getDocument(), condition.getCondition(), true);
    }

    public static DefaultDocumentCondition of(Document document, Condition condition) {
        return new DefaultDocumentCondition(Objects.requireNonNull(document, "Document is required"), condition);
    }

    static DocumentCondition between(Document document) {
        Objects.requireNonNull(document, "document is required");
        DefaultDocumentCondition.checkBetweenClause(document.get());
        return new DefaultDocumentCondition(document, Condition.BETWEEN);
    }

    static DocumentCondition in(Document document) {
        Objects.requireNonNull(document, "document is required");
        Value value = document.getValue();
        DefaultDocumentCondition.checkInClause(value);
        return new DefaultDocumentCondition(document, Condition.IN);
    }

    private static void checkInClause(Value value) {
        if (!value.isInstanceOf(Iterable.class)) {
            throw new IllegalArgumentException("On DocumentCondition#in you must use an iterable instead of class: " + value.getClass().getName());
        }
    }

    private static void checkBetweenClause(Object value) {
        if (Iterable.class.isInstance(value)) {
            long count = (int)StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).count();
            if (count != 2L) {
                throw new IllegalArgumentException("On DocumentCondition#between you must use an iterable with two elements");
            }
        } else {
            throw new IllegalArgumentException("On DocumentCondition#between you must use an iterable with two elements instead of class: " + value.getClass().getName());
        }
    }

    static DefaultDocumentCondition and(DocumentCondition ... conditions) {
        Objects.requireNonNull(conditions, "condition is required");
        Document document = Document.of((String)Condition.AND.getNameField(), Arrays.asList(conditions));
        return DefaultDocumentCondition.of(document, Condition.AND);
    }

    static DefaultDocumentCondition or(DocumentCondition ... conditions) {
        Objects.requireNonNull(conditions, "condition is required");
        Document document = Document.of((String)Condition.OR.getNameField(), Arrays.asList(conditions));
        return DefaultDocumentCondition.of(document, Condition.OR);
    }

    public Document getDocument() {
        return this.document;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public DocumentCondition and(DocumentCondition condition) {
        this.validateReadOnly();
        Objects.requireNonNull(condition, "Conditions is required");
        if (Condition.AND.equals((Object)this.condition)) {
            Document column = this.getConditions(condition, Condition.AND);
            return new DefaultDocumentCondition(column, Condition.AND);
        }
        return DefaultDocumentCondition.and(this, condition);
    }

    public DocumentCondition negate() {
        this.validateReadOnly();
        if (Condition.NOT.equals((Object)this.condition)) {
            return (DocumentCondition)this.document.get(DocumentCondition.class);
        }
        Document newDocument = Document.of((String)Condition.NOT.getNameField(), (Object)this);
        return new DefaultDocumentCondition(newDocument, Condition.NOT);
    }

    public DocumentCondition or(DocumentCondition condition) {
        this.validateReadOnly();
        Objects.requireNonNull(condition, "Condition is required");
        if (Condition.OR.equals((Object)this.condition)) {
            Document newDocument = this.getConditions(condition, Condition.OR);
            return new DefaultDocumentCondition(newDocument, Condition.OR);
        }
        return DefaultDocumentCondition.or(this, condition);
    }

    private void validateReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("You cannot change the status after building the query");
        }
    }

    private Document getConditions(DocumentCondition columnCondition, Condition condition) {
        ArrayList<DocumentCondition> conditions = new ArrayList<DocumentCondition>((Collection)this.document.get((TypeSupplier)new TypeReference<List<DocumentCondition>>(){}));
        conditions.add(columnCondition);
        return Document.of((String)condition.getNameField(), conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !DocumentCondition.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        DocumentCondition that = (DocumentCondition)o;
        return Objects.equals(this.document, that.getDocument()) && this.condition == that.getCondition();
    }

    public int hashCode() {
        return Objects.hash(this.document, this.condition);
    }

    public String toString() {
        return "DefaultDocumentCondition{document=" + this.document + ", condition=" + this.condition + "}";
    }
}

