/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.document.DocumentObserverParser;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.BiFunction;

final class CacheQuery<V> {
    private final Map<String, V> store = Collections.synchronizedMap(new WeakHashMap());
    private final BiFunction<String, DocumentObserverParser, V> supplier;

    CacheQuery(BiFunction<String, DocumentObserverParser, V> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(String key, DocumentObserverParser observer) {
        V value = this.store.get(key);
        if (Objects.isNull(value)) {
            CacheQuery cacheQuery = this;
            synchronized (cacheQuery) {
                value = this.supplier.apply(key, observer);
                this.put(key, value);
            }
        }
        return value;
    }

    private V put(String key, V value) {
        return this.store.put(key, value);
    }
}

