/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.document.Document;
import jakarta.nosql.document.DocumentCondition;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentObserverParser;
import jakarta.nosql.query.JSONQueryValue;
import java.util.List;
import javax.json.JsonObject;
import org.eclipse.jnosql.communication.document.query.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.document.query.Conditions;
import org.eclipse.jnosql.communication.document.query.JsonObjects;

abstract class ConditionQueryParser {
    ConditionQueryParser() {
    }

    protected DocumentEntity getEntity(ConditionQuerySupplier query, String collection, Params params, DocumentObserverParser observer) {
        DocumentEntity entity = DocumentEntity.of((String)collection);
        if (query.useJSONCondition()) {
            JSONQueryValue jsonValue = query.getValue().orElseThrow(() -> new QueryException("It is an invalid state of either Update or Insert."));
            List<Document> documents = JsonObjects.getDocuments((JsonObject)jsonValue.get());
            entity.addAll(documents);
            return entity;
        }
        query.getConditions().stream().map(c -> Conditions.getCondition(c, params, observer, collection)).map(DocumentCondition::getDocument).forEach(arg_0 -> ((DocumentEntity)entity).add(arg_0));
        return entity;
    }
}

