/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.document.Document;
import jakarta.nosql.document.DocumentCondition;
import jakarta.nosql.document.DocumentObserverParser;
import jakarta.nosql.query.Condition;
import jakarta.nosql.query.ConditionQueryValue;
import jakarta.nosql.query.Where;
import java.util.List;
import org.eclipse.jnosql.communication.document.query.Values;

final class Conditions {
    private Conditions() {
    }

    static DocumentCondition getCondition(Where where, Params params, DocumentObserverParser observer, String entity) {
        Condition condition = where.getCondition();
        return Conditions.getCondition(condition, params, observer, entity);
    }

    static DocumentCondition getCondition(Condition condition, Params parameters, DocumentObserverParser observer, String entity) {
        switch (condition.getOperator()) {
            case EQUALS: {
                return DocumentCondition.eq((Document)Document.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case GREATER_THAN: {
                return DocumentCondition.gt((Document)Document.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case GREATER_EQUALS_THAN: {
                return DocumentCondition.gte((Document)Document.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case LESSER_THAN: {
                return DocumentCondition.lt((Document)Document.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case LESSER_EQUALS_THAN: {
                return DocumentCondition.lte((Document)Document.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case IN: {
                return DocumentCondition.in((Document)Document.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case LIKE: {
                return DocumentCondition.like((Document)Document.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case BETWEEN: {
                return DocumentCondition.between((Document)Document.of((String)Conditions.getName(condition, observer, entity), (Object)Values.get(condition.getValue(), parameters)));
            }
            case NOT: {
                return Conditions.getCondition((Condition)((List)((ConditionQueryValue)ConditionQueryValue.class.cast(condition.getValue())).get()).get(0), parameters, observer, entity).negate();
            }
            case OR: {
                return DocumentCondition.or((DocumentCondition[])((DocumentCondition[])((List)((ConditionQueryValue)ConditionQueryValue.class.cast(condition.getValue())).get()).stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(DocumentCondition[]::new)));
            }
            case AND: {
                return DocumentCondition.and((DocumentCondition[])((DocumentCondition[])((List)((ConditionQueryValue)ConditionQueryValue.class.cast(condition.getValue())).get()).stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(DocumentCondition[]::new)));
            }
        }
        throw new QueryException("There is not support the type: " + condition.getOperator());
    }

    private static String getName(Condition condition, DocumentObserverParser observer, String entity) {
        return observer.fireField(entity, condition.getName());
    }
}

