/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.Sort;
import jakarta.nosql.document.DocumentCondition;
import jakarta.nosql.document.DocumentDeleteQuery;
import jakarta.nosql.document.DocumentManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.query.DefaultDocumentDeleteQuery;

class DefaultDeleteQueryBuilder
implements DocumentDeleteQuery.DocumentDeleteQueryBuilder {
    private final List<String> documents = new ArrayList<String>();
    private final List<Sort> sorts = new ArrayList<Sort>();
    private String documentCollection;
    private DocumentCondition condition;

    DefaultDeleteQueryBuilder() {
    }

    public DocumentDeleteQuery.DocumentDeleteQueryBuilder delete(String document) {
        Objects.requireNonNull(document, "document is required");
        this.documents.add(document);
        return this;
    }

    public DocumentDeleteQuery.DocumentDeleteQueryBuilder delete(String ... documents) {
        Consumer<String> validNull = d -> Objects.requireNonNull(d, "there is null document in the query");
        Consumer<String> consume = this.documents::add;
        Stream.of(documents).forEach(validNull.andThen(consume));
        return this;
    }

    public DocumentDeleteQuery.DocumentDeleteQueryBuilder from(String documentCollection) {
        Objects.requireNonNull(documentCollection, "documentCollection is required");
        this.documentCollection = documentCollection;
        return this;
    }

    public DocumentDeleteQuery.DocumentDeleteQueryBuilder where(DocumentCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        this.condition = condition;
        return this;
    }

    public DocumentDeleteQuery build() {
        if (Objects.isNull(this.documentCollection)) {
            throw new IllegalArgumentException("The document collection is mandatory to build");
        }
        return new DefaultDocumentDeleteQuery(this.documentCollection, this.condition, this.documents);
    }

    public void delete(DocumentManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        manager.delete(this.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDeleteQueryBuilder that = (DefaultDeleteQueryBuilder)o;
        return Objects.equals(this.documents, that.documents) && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.documentCollection, that.documentCollection) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.documents, this.sorts, this.documentCollection, this.condition);
    }

    public String toString() {
        return "DefaultDeleteQueryBuilder{documents=" + this.documents + ", sorts=" + this.sorts + ", documentCollection='" + this.documentCollection + "', condition=" + this.condition + "}";
    }
}

