/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.document.DocumentCondition;
import jakarta.nosql.document.DocumentDeleteQuery;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.document.DefaultDocumentCondition;

class DefaultDocumentDeleteQuery
implements DocumentDeleteQuery {
    private final String documentCollection;
    private final DocumentCondition condition;
    private final List<String> documents;

    DefaultDocumentDeleteQuery(String documentCollection, DocumentCondition condition, List<String> documents) {
        this.documentCollection = documentCollection;
        this.condition = Optional.ofNullable(condition).map(DefaultDocumentCondition::readOnly).orElse(null);
        this.documents = documents;
    }

    public String getDocumentCollection() {
        return this.documentCollection;
    }

    public Optional<DocumentCondition> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    public List<String> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDeleteQuery)) {
            return false;
        }
        DocumentDeleteQuery that = (DocumentDeleteQuery)o;
        return Objects.equals(this.documentCollection, that.getDocumentCollection()) && Objects.equals(this.condition, that.getCondition().orElse(null)) && Objects.equals(this.documents, that.getDocuments());
    }

    public int hashCode() {
        return Objects.hash(this.documentCollection, this.condition, this.documents);
    }

    public String toString() {
        return "DefaultDocumentDeleteQuery{documentCollection='" + this.documentCollection + "', condition=" + this.condition + ", documents=" + this.documents + "}";
    }
}

