/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.document.DocumentDeleteQuery;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.document.DocumentPreparedStatement;
import jakarta.nosql.document.DocumentQuery;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

final class DefaultDocumentPreparedStatement
implements DocumentPreparedStatement {
    private final DocumentEntity entity;
    private final DocumentQuery documentQuery;
    private final DocumentDeleteQuery documentDeleteQuery;
    private final PreparedStatementType type;
    private final Params params;
    private final String query;
    private final List<String> paramsLeft;
    private final Duration duration;
    private final DocumentManager manager;

    private DefaultDocumentPreparedStatement(DocumentEntity entity, DocumentQuery documentQuery, DocumentDeleteQuery documentDeleteQuery, PreparedStatementType type, Params params, String query, List<String> paramsLeft, Duration duration, DocumentManager manager) {
        this.entity = entity;
        this.documentQuery = documentQuery;
        this.documentDeleteQuery = documentDeleteQuery;
        this.type = type;
        this.params = params;
        this.query = query;
        this.paramsLeft = paramsLeft;
        this.manager = manager;
        this.duration = duration;
    }

    public DocumentPreparedStatement bind(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.paramsLeft.remove(name);
        this.params.bind(name, value);
        return this;
    }

    public Stream<DocumentEntity> getResult() {
        if (!this.paramsLeft.isEmpty()) {
            throw new QueryException("Check all the parameters before execute the query, params left: " + this.paramsLeft);
        }
        switch (this.type) {
            case SELECT: {
                return this.manager.select(this.documentQuery);
            }
            case DELETE: {
                this.manager.delete(this.documentDeleteQuery);
                return Stream.empty();
            }
            case UPDATE: {
                return Stream.of(this.manager.update(this.entity));
            }
            case INSERT: {
                if (Objects.isNull(this.duration)) {
                    return Stream.of(this.manager.insert(this.entity));
                }
                return Stream.of(this.manager.insert(this.entity, this.duration));
            }
        }
        throw new UnsupportedOperationException("there is not support to operation type: " + this.type);
    }

    public Optional<DocumentEntity> getSingleResult() {
        Stream<DocumentEntity> entities = this.getResult();
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        DocumentEntity next = (DocumentEntity)iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(next);
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + this.query);
    }

    public String toString() {
        return this.query;
    }

    static DocumentPreparedStatement select(DocumentQuery documentQuery, Params params, String query, DocumentManager manager) {
        return new DefaultDocumentPreparedStatement(null, documentQuery, null, PreparedStatementType.SELECT, params, query, params.getParametersNames(), null, manager);
    }

    static DocumentPreparedStatement delete(DocumentDeleteQuery documentDeleteQuery, Params params, String query, DocumentManager manager) {
        return new DefaultDocumentPreparedStatement(null, null, documentDeleteQuery, PreparedStatementType.DELETE, params, query, params.getParametersNames(), null, manager);
    }

    static DocumentPreparedStatement insert(DocumentEntity entity, Params params, String query, Duration duration, DocumentManager manager) {
        return new DefaultDocumentPreparedStatement(entity, null, null, PreparedStatementType.INSERT, params, query, params.getParametersNames(), duration, manager);
    }

    static DocumentPreparedStatement update(DocumentEntity entity, Params params, String query, DocumentManager manager) {
        return new DefaultDocumentPreparedStatement(entity, null, null, PreparedStatementType.UPDATE, params, query, params.getParametersNames(), null, manager);
    }

    static enum PreparedStatementType {
        SELECT,
        DELETE,
        UPDATE,
        INSERT;

    }
}

