/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.Sort;
import jakarta.nosql.document.DocumentCondition;
import jakarta.nosql.document.DocumentQuery;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.document.DefaultDocumentCondition;

class DefaultDocumentQuery
implements DocumentQuery {
    private final long limit;
    private final long skip;
    private final String documentCollection;
    private final DocumentCondition condition;
    private final List<Sort> sorts;
    private final List<String> documents;

    DefaultDocumentQuery(long limit, long skip, String documentCollection, List<String> documents, List<Sort> sorts, DocumentCondition condition) {
        this.limit = limit;
        this.skip = skip;
        this.documentCollection = documentCollection;
        this.condition = Optional.ofNullable(condition).map(DefaultDocumentCondition::readOnly).orElse(null);
        this.sorts = sorts;
        this.documents = documents;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getSkip() {
        return this.skip;
    }

    public String getDocumentCollection() {
        return this.documentCollection;
    }

    public Optional<DocumentCondition> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    public List<Sort> getSorts() {
        return Collections.unmodifiableList(this.sorts);
    }

    public List<String> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentQuery)) {
            return false;
        }
        DocumentQuery that = (DocumentQuery)o;
        return this.limit == that.getLimit() && this.skip == that.getSkip() && Objects.equals(this.documentCollection, that.getDocumentCollection()) && Objects.equals(this.condition, that.getCondition().orElse(null)) && Objects.equals(this.sorts, that.getSorts()) && Objects.equals(this.documents, that.getDocuments());
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.skip, this.documentCollection, this.condition, this.sorts, this.documents);
    }

    public String toString() {
        return "DefaultDocumentQuery{maxResult=" + this.limit + ", firstResult=" + this.skip + ", documentCollection='" + this.documentCollection + "', condition=" + this.condition + ", sorts=" + this.sorts + ", documents=" + this.documents + "}";
    }
}

