/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.QueryException;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.document.DocumentObserverParser;
import jakarta.nosql.document.DocumentPreparedStatement;
import jakarta.nosql.document.DocumentQueryParser;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.query.DeleteQueryParser;
import org.eclipse.jnosql.communication.document.query.InsertQueryParser;
import org.eclipse.jnosql.communication.document.query.SelectQueryParser;
import org.eclipse.jnosql.communication.document.query.UpdateQueryParser;

public final class DefaultDocumentQueryParser
implements DocumentQueryParser {
    private final SelectQueryParser select = new SelectQueryParser();
    private final DeleteQueryParser delete = new DeleteQueryParser();
    private final InsertQueryParser insert = new InsertQueryParser();
    private final UpdateQueryParser update = new UpdateQueryParser();

    public Stream<DocumentEntity> query(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        String command;
        this.validation(query, collectionManager, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                return this.select.query(query, collectionManager, observer);
            }
            case "delete": {
                return this.delete.query(query, collectionManager, observer);
            }
            case "insert": {
                return this.insert.query(query, collectionManager, observer);
            }
            case "update": {
                return this.update.query(query, collectionManager, observer);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    public DocumentPreparedStatement prepare(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        String command;
        this.validation(query, collectionManager, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                return this.select.prepare(query, collectionManager, observer);
            }
            case "delete": {
                return this.delete.prepare(query, collectionManager, observer);
            }
            case "insert": {
                return this.insert.prepare(query, collectionManager, observer);
            }
            case "update": {
                return this.update.prepare(query, collectionManager, observer);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    private void validation(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(collectionManager, "collectionManager is required");
        Objects.requireNonNull(observer, "observer is required");
        if (query.length() < 6) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }
}

