/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.Sort;
import jakarta.nosql.SortType;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.document.DocumentQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.query.BaseQueryBuilder;
import org.eclipse.jnosql.communication.document.query.DefaultDocumentQuery;

class DefaultFluentDocumentQueryBuilder
extends BaseQueryBuilder
implements DocumentQuery.DocumentSelect,
DocumentQuery.DocumentFrom,
DocumentQuery.DocumentLimit,
DocumentQuery.DocumentSkip,
DocumentQuery.DocumentOrder,
DocumentQuery.DocumentNotCondition,
DocumentQuery.DocumentNameOrder,
DocumentQuery.DocumentWhere,
DocumentQuery.DocumentQueryBuild {
    private String documentCollection;
    private long skip;
    private long limit;
    private final List<Sort> sorts = new ArrayList<Sort>();
    private final List<String> documents;

    DefaultFluentDocumentQueryBuilder(List<String> documents) {
        this.documents = documents;
    }

    public DocumentQuery.DocumentFrom from(String documentCollection) {
        Objects.requireNonNull(documentCollection, "documentCollection is required");
        this.documentCollection = documentCollection;
        return this;
    }

    public DocumentQuery.DocumentNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public DocumentQuery.DocumentNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    public DocumentQuery.DocumentNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    public DocumentQuery.DocumentSkip skip(long skip) {
        if (skip < 0L) {
            throw new IllegalArgumentException("The skip should not be negative, skip: " + skip);
        }
        this.skip = skip;
        return this;
    }

    public DocumentQuery.DocumentLimit limit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("The limit should not be negative, limit: " + limit);
        }
        this.limit = limit;
        return this;
    }

    public DocumentQuery.DocumentOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public DocumentQuery.DocumentNotCondition not() {
        this.negate = true;
        return this;
    }

    public <T> DocumentQuery.DocumentWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    public DocumentQuery.DocumentWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    public <T> DocumentQuery.DocumentWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    public <T> DocumentQuery.DocumentWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    public <T> DocumentQuery.DocumentWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    public <T> DocumentQuery.DocumentWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    public <T> DocumentQuery.DocumentWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    public <T> DocumentQuery.DocumentWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    public DocumentQuery.DocumentNameOrder asc() {
        this.sorts.add(Sort.of((String)this.name, (SortType)SortType.ASC));
        return this;
    }

    public DocumentQuery.DocumentNameOrder desc() {
        this.sorts.add(Sort.of((String)this.name, (SortType)SortType.DESC));
        return this;
    }

    public DocumentQuery build() {
        return new DefaultDocumentQuery(this.limit, this.skip, this.documentCollection, this.documents, this.sorts, this.condition);
    }

    public Stream<DocumentEntity> getResult(DocumentManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.select(this.build());
    }

    public Optional<DocumentEntity> getSingleResult(DocumentManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.singleResult(this.build());
    }
}

