/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.document.DeleteQueryConverter;
import jakarta.nosql.document.DocumentCondition;
import jakarta.nosql.document.DocumentDeleteQuery;
import jakarta.nosql.document.DocumentDeleteQueryParams;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.document.DocumentObserverParser;
import jakarta.nosql.document.DocumentPreparedStatement;
import jakarta.nosql.query.DeleteQuery;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.query.CacheQuery;
import org.eclipse.jnosql.communication.document.query.Conditions;
import org.eclipse.jnosql.communication.document.query.DefaultDocumentDeleteQuery;
import org.eclipse.jnosql.communication.document.query.DefaultDocumentDeleteQueryParams;
import org.eclipse.jnosql.communication.document.query.DefaultDocumentPreparedStatement;

public final class DeleteQueryParser
implements DeleteQueryConverter {
    private final DeleteQuery.DeleteQueryProvider deleteQueryProvider = DeleteQuery.getProvider();
    private final CacheQuery<DocumentDeleteQuery> cache = new CacheQuery<DocumentDeleteQuery>(this::getQuery);

    Stream<DocumentEntity> query(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        DocumentDeleteQuery documentQuery = this.cache.get(query, observer);
        collectionManager.delete(documentQuery);
        return Stream.empty();
    }

    DocumentPreparedStatement prepare(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        Params params = Params.newParams();
        DocumentDeleteQuery documentQuery = this.getQuery(query, params, observer);
        return DefaultDocumentPreparedStatement.delete(documentQuery, params, query, collectionManager);
    }

    public DocumentDeleteQueryParams apply(DeleteQuery deleteQuery, DocumentObserverParser observer) {
        Objects.requireNonNull(deleteQuery, "deleteQuery is required");
        Objects.requireNonNull(observer, "observer is required");
        Params params = Params.newParams();
        DocumentDeleteQuery query = this.getQuery(params, observer, deleteQuery);
        return new DefaultDocumentDeleteQueryParams(query, params);
    }

    private DocumentDeleteQuery getQuery(String query, Params params, DocumentObserverParser observer) {
        DeleteQuery deleteQuery = (DeleteQuery)this.deleteQueryProvider.apply((Object)query);
        return this.getQuery(params, observer, deleteQuery);
    }

    private DocumentDeleteQuery getQuery(Params params, DocumentObserverParser observer, DeleteQuery deleteQuery) {
        String collection = observer.fireEntity(deleteQuery.getEntity());
        List<String> documents = deleteQuery.getFields().stream().map(f -> observer.fireField(collection, f)).collect(Collectors.toList());
        DocumentCondition condition = null;
        if (deleteQuery.getWhere().isPresent()) {
            condition = deleteQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, collection)).get();
        }
        return new DefaultDocumentDeleteQuery(collection, condition, documents);
    }

    private DocumentDeleteQuery getQuery(String query, DocumentObserverParser observer) {
        DeleteQuery deleteQuery = (DeleteQuery)this.deleteQueryProvider.apply((Object)query);
        String collection = observer.fireEntity(deleteQuery.getEntity());
        List<String> documents = deleteQuery.getFields().stream().map(f -> observer.fireField(collection, f)).collect(Collectors.toList());
        DocumentCondition condition = null;
        Params params = Params.newParams();
        if (deleteQuery.getWhere().isPresent()) {
            condition = deleteQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, collection)).get();
        }
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultDocumentDeleteQuery(collection, condition, documents);
    }
}

