/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.document.DocumentObserverParser;
import jakarta.nosql.document.DocumentPreparedStatement;
import jakarta.nosql.query.Condition;
import jakarta.nosql.query.InsertQuery;
import jakarta.nosql.query.JSONQueryValue;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.query.ConditionQueryParser;
import org.eclipse.jnosql.communication.document.query.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.document.query.DefaultDocumentPreparedStatement;

final class InsertQueryParser
extends ConditionQueryParser {
    private final InsertQuery.InsertQueryProvider insertQueryProvider = InsertQuery.getProvider();

    InsertQueryParser() {
    }

    Stream<DocumentEntity> query(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        InsertQuery insertQuery = (InsertQuery)this.insertQueryProvider.apply((Object)query);
        String collection = insertQuery.getEntity();
        Params params = Params.newParams();
        DocumentEntity entity = this.getEntity(insertQuery, collection, params, observer);
        Optional ttl = insertQuery.getTtl();
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        if (ttl.isPresent()) {
            return Stream.of(collectionManager.insert(entity, (Duration)ttl.get()));
        }
        return Stream.of(collectionManager.insert(entity));
    }

    DocumentPreparedStatement prepare(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        InsertQuery insertQuery = (InsertQuery)this.insertQueryProvider.apply((Object)query);
        String collection = observer.fireEntity(insertQuery.getEntity());
        Params params = Params.newParams();
        Optional ttl = insertQuery.getTtl();
        DocumentEntity entity = this.getEntity(insertQuery, collection, params, observer);
        return DefaultDocumentPreparedStatement.insert(entity, params, query, ttl.orElse(null), collectionManager);
    }

    private DocumentEntity getEntity(InsertQuery insertQuery, String collection, Params params, DocumentObserverParser observer) {
        return this.getEntity(new InsertQueryConditionSupplier(insertQuery), collection, params, observer);
    }

    private static final class InsertQueryConditionSupplier
    implements ConditionQuerySupplier {
        private final InsertQuery query;

        private InsertQueryConditionSupplier(InsertQuery query) {
            this.query = query;
        }

        @Override
        public List<Condition> getConditions() {
            return this.query.getConditions();
        }

        @Override
        public Optional<JSONQueryValue> getValue() {
            return this.query.getValue();
        }
    }
}

