/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.Sort;
import jakarta.nosql.SortType;
import jakarta.nosql.document.DocumentCondition;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.document.DocumentObserverParser;
import jakarta.nosql.document.DocumentPreparedStatement;
import jakarta.nosql.document.DocumentQuery;
import jakarta.nosql.document.DocumentQueryParams;
import jakarta.nosql.document.SelectQueryConverter;
import jakarta.nosql.query.SelectQuery;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.query.CacheQuery;
import org.eclipse.jnosql.communication.document.query.Conditions;
import org.eclipse.jnosql.communication.document.query.DefaultDocumentPreparedStatement;
import org.eclipse.jnosql.communication.document.query.DefaultDocumentQuery;
import org.eclipse.jnosql.communication.document.query.DefaultDocumentQueryParams;

public final class SelectQueryParser
implements SelectQueryConverter {
    private final SelectQuery.SelectQueryProvider selectQueryProvider = SelectQuery.getProvider();
    private final CacheQuery<DocumentQuery> cache = new CacheQuery<DocumentQuery>(this::getDocumentQuery);

    Stream<DocumentEntity> query(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        DocumentQuery documentQuery = this.cache.get(query, observer);
        return collectionManager.select(documentQuery);
    }

    DocumentPreparedStatement prepare(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        Params params = Params.newParams();
        SelectQuery selectQuery = (SelectQuery)this.selectQueryProvider.apply((Object)query);
        DocumentQuery documentQuery = this.getDocumentQuery(params, selectQuery, observer);
        return DefaultDocumentPreparedStatement.select(documentQuery, params, query, collectionManager);
    }

    public DocumentQueryParams apply(SelectQuery selectQuery, DocumentObserverParser observer) {
        Objects.requireNonNull(selectQuery, "selectQuery is required");
        Objects.requireNonNull(observer, "observer is required");
        Params params = Params.newParams();
        DocumentQuery columnQuery = this.getDocumentQuery(params, selectQuery, observer);
        return new DefaultDocumentQueryParams(columnQuery, params);
    }

    private DocumentQuery getDocumentQuery(String query, DocumentObserverParser observer) {
        SelectQuery selectQuery = (SelectQuery)this.selectQueryProvider.apply((Object)query);
        String collection = observer.fireEntity(selectQuery.getEntity());
        long limit = selectQuery.getLimit();
        long skip = selectQuery.getSkip();
        List<String> documents = selectQuery.getFields().stream().map(f -> observer.fireField(collection, f)).collect(Collectors.toList());
        List<Sort> sorts = selectQuery.getOrderBy().stream().map(s -> this.toSort((Sort)s, observer, collection)).collect(Collectors.toList());
        DocumentCondition condition = null;
        Params params = Params.newParams();
        if (selectQuery.getWhere().isPresent()) {
            condition = selectQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, collection)).get();
        }
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultDocumentQuery(limit, skip, collection, documents, sorts, condition);
    }

    private DocumentQuery getDocumentQuery(Params params, SelectQuery selectQuery, DocumentObserverParser observer) {
        String collection = observer.fireEntity(selectQuery.getEntity());
        long limit = selectQuery.getLimit();
        long skip = selectQuery.getSkip();
        List<String> documents = selectQuery.getFields().stream().map(f -> observer.fireField(collection, f)).collect(Collectors.toList());
        List<Sort> sorts = selectQuery.getOrderBy().stream().map(s -> this.toSort((Sort)s, observer, collection)).collect(Collectors.toList());
        DocumentCondition condition = null;
        if (selectQuery.getWhere().isPresent()) {
            condition = selectQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, collection)).get();
        }
        return new DefaultDocumentQuery(limit, skip, collection, documents, sorts, condition);
    }

    private Sort toSort(Sort sort, DocumentObserverParser observer, String entity) {
        return Sort.of((String)observer.fireField(entity, sort.getName()), (SortType)sort.getType());
    }
}

