/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.document.DocumentObserverParser;
import jakarta.nosql.document.DocumentPreparedStatement;
import jakarta.nosql.query.Condition;
import jakarta.nosql.query.JSONQueryValue;
import jakarta.nosql.query.UpdateQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.query.ConditionQueryParser;
import org.eclipse.jnosql.communication.document.query.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.document.query.DefaultDocumentPreparedStatement;

final class UpdateQueryParser
extends ConditionQueryParser {
    private final UpdateQuery.UpdateQueryProvider supplier = UpdateQuery.getProvider();

    UpdateQueryParser() {
    }

    Stream<DocumentEntity> query(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        UpdateQuery updateQuery = (UpdateQuery)this.supplier.apply((Object)query);
        Params params = Params.newParams();
        DocumentEntity entity = this.getEntity(params, updateQuery, observer);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return Stream.of(collectionManager.update(entity));
    }

    DocumentPreparedStatement prepare(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        Params params = Params.newParams();
        UpdateQuery updateQuery = (UpdateQuery)this.supplier.apply((Object)query);
        DocumentEntity entity = this.getEntity(params, updateQuery, observer);
        return DefaultDocumentPreparedStatement.update(entity, params, query, collectionManager);
    }

    private DocumentEntity getEntity(Params params, UpdateQuery updateQuery, DocumentObserverParser observer) {
        String collection = observer.fireEntity(updateQuery.getEntity());
        return this.getEntity(new UpdateQueryConditioinSupplier(updateQuery), collection, params, observer);
    }

    private static final class UpdateQueryConditioinSupplier
    implements ConditionQuerySupplier {
        private final UpdateQuery query;

        private UpdateQueryConditioinSupplier(UpdateQuery query) {
            this.query = query;
        }

        @Override
        public List<Condition> getConditions() {
            return this.query.getConditions();
        }

        @Override
        public Optional<JSONQueryValue> getValue() {
            return this.query.getValue();
        }
    }
}

