/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jnosql.communication.document.Document;
import org.eclipse.jnosql.communication.document.DocumentCondition;

abstract class BaseQueryBuilder {
    protected String name;
    protected boolean negate;
    protected boolean and;
    protected DocumentCondition condition;

    BaseQueryBuilder() {
    }

    protected <T> void eqImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.eq(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void gtImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.gt(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected void likeImpl(String value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.like(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void ltImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.lt(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void lteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.lte(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void gteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.gte(Document.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void betweenImpl(T valueA, T valueB) {
        Objects.requireNonNull(valueA, "valueA is required");
        Objects.requireNonNull(valueB, "valueB is required");
        DocumentCondition newCondition = DocumentCondition.between(Document.of(this.name, Arrays.asList(valueA, valueB)));
        this.appendCondition(newCondition);
    }

    protected <T> void inImpl(Iterable<T> values) {
        Objects.requireNonNull(values, "values is required");
        DocumentCondition newCondition = DocumentCondition.in(Document.of(this.name, values));
        this.appendCondition(newCondition);
    }

    protected void appendCondition(DocumentCondition newCondition) {
        DocumentCondition documentCondition = this.getDocumentCondition(newCondition);
        this.condition = Objects.nonNull(this.condition) ? (this.and ? this.condition.and(documentCondition) : this.condition.or(documentCondition)) : documentCondition;
        this.negate = false;
        this.name = null;
    }

    private DocumentCondition getDocumentCondition(DocumentCondition newCondition) {
        if (this.negate) {
            return newCondition.negate();
        }
        return newCondition;
    }
}

