/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import java.util.List;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.document.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.document.Conditions;
import org.eclipse.jnosql.communication.document.Document;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.communication.document.DocumentObserverParser;
import org.eclipse.jnosql.communication.document.JsonObjects;
import org.eclipse.jnosql.communication.query.JSONQueryValue;

abstract class ConditionQueryParser {
    ConditionQueryParser() {
    }

    protected DocumentEntity getEntity(ConditionQuerySupplier query, String collection, Params params, DocumentObserverParser observer) {
        DocumentEntity entity = DocumentEntity.of(collection);
        if (query.useJSONCondition()) {
            JSONQueryValue jsonValue = query.value().orElseThrow(() -> new QueryException("It is an invalid state of either Update or Insert."));
            List<Document> documents = JsonObjects.getDocuments(jsonValue.get());
            entity.addAll(documents);
            return entity;
        }
        query.conditions().stream().map(c -> Conditions.getCondition(c, params, observer, collection)).map(DocumentCondition::document).forEach(entity::add);
        return entity;
    }
}

