/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.document.Document;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.document.DocumentObserverParser;
import org.eclipse.jnosql.communication.document.Values;
import org.eclipse.jnosql.communication.query.ConditionQueryValue;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.query.Where;

final class Conditions {
    private Conditions() {
    }

    static DocumentCondition getCondition(Where where, Params params, DocumentObserverParser observer, String entity) {
        QueryCondition condition = where.condition();
        return Conditions.getCondition(condition, params, observer, entity);
    }

    static DocumentCondition getCondition(QueryCondition condition, Params parameters, DocumentObserverParser observer, String entity) {
        return switch (condition.condition()) {
            case Condition.EQUALS -> DocumentCondition.eq(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.GREATER_THAN -> DocumentCondition.gt(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.GREATER_EQUALS_THAN -> DocumentCondition.gte(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.LESSER_THAN -> DocumentCondition.lt(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.LESSER_EQUALS_THAN -> DocumentCondition.lte(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.IN -> DocumentCondition.in(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.LIKE -> DocumentCondition.like(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.BETWEEN -> DocumentCondition.between(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.NOT -> Conditions.getCondition((QueryCondition)((ConditionQueryValue)ConditionQueryValue.class.cast(condition.value())).get().get(0), parameters, observer, entity).negate();
            case Condition.OR -> DocumentCondition.or((DocumentCondition[])((ConditionQueryValue)ConditionQueryValue.class.cast(condition.value())).get().stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(DocumentCondition[]::new));
            case Condition.AND -> DocumentCondition.and((DocumentCondition[])((ConditionQueryValue)ConditionQueryValue.class.cast(condition.value())).get().stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(DocumentCondition[]::new));
            default -> throw new QueryException("There is not support the type: " + condition.condition());
        };
    }

    private static String getName(QueryCondition condition, DocumentObserverParser observer, String entity) {
        return observer.fireField(entity, condition.name());
    }
}

