/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.document.DocumentDeleteQuery;

final class DefaultDocumentDeleteQuery
implements DocumentDeleteQuery {
    private final String documentCollection;
    private final DocumentCondition condition;
    private final List<String> documents;

    DefaultDocumentDeleteQuery(String documentCollection, DocumentCondition condition, List<String> documents) {
        this.documentCollection = documentCollection;
        this.condition = Optional.ofNullable(condition).map(DocumentCondition::readOnly).orElse(null);
        this.documents = documents;
    }

    @Override
    public String name() {
        return this.documentCollection;
    }

    @Override
    public Optional<DocumentCondition> condition() {
        return Optional.ofNullable(this.condition);
    }

    @Override
    public List<String> documents() {
        return Collections.unmodifiableList(this.documents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDeleteQuery)) {
            return false;
        }
        DocumentDeleteQuery that = (DocumentDeleteQuery)o;
        return Objects.equals(this.documentCollection, that.name()) && Objects.equals(this.condition, that.condition().orElse(null)) && Objects.equals(this.documents, that.documents());
    }

    public int hashCode() {
        return Objects.hash(this.documentCollection, this.condition, this.documents);
    }

    public String toString() {
        return "DefaultDocumentDeleteQuery{documentCollection='" + this.documentCollection + "', condition=" + this.condition + ", documents=" + this.documents + "}";
    }
}

