/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import jakarta.data.repository.Sort;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.DefaultDocumentDeleteQuery;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.document.DocumentDeleteQuery;
import org.eclipse.jnosql.communication.document.DocumentManager;

final class DefaultDocumentDeleteQueryBuilder
implements DocumentDeleteQuery.DocumentDeleteQueryBuilder {
    private final List<String> documents = new ArrayList<String>();
    private final List<Sort> sorts = new ArrayList<Sort>();
    private String documentCollection;
    private DocumentCondition condition;

    DefaultDocumentDeleteQueryBuilder() {
    }

    @Override
    public DefaultDocumentDeleteQueryBuilder delete(String document) {
        Objects.requireNonNull(document, "document is required");
        this.documents.add(document);
        return this;
    }

    @Override
    public DefaultDocumentDeleteQueryBuilder delete(String ... documents) {
        Consumer<String> validNull = d -> Objects.requireNonNull(d, "there is null document in the query");
        Consumer<String> consume = this.documents::add;
        Stream.of(documents).forEach(validNull.andThen(consume));
        return this;
    }

    @Override
    public DefaultDocumentDeleteQueryBuilder from(String documentCollection) {
        Objects.requireNonNull(documentCollection, "documentCollection is required");
        this.documentCollection = documentCollection;
        return this;
    }

    @Override
    public DefaultDocumentDeleteQueryBuilder where(DocumentCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        this.condition = condition;
        return this;
    }

    @Override
    public DocumentDeleteQuery build() {
        if (Objects.isNull(this.documentCollection)) {
            throw new IllegalArgumentException("The document collection is mandatory to build");
        }
        return new DefaultDocumentDeleteQuery(this.documentCollection, this.condition, this.documents);
    }

    @Override
    public void delete(DocumentManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        manager.delete(this.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDocumentDeleteQueryBuilder that = (DefaultDocumentDeleteQueryBuilder)o;
        return Objects.equals(this.documents, that.documents) && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.documentCollection, that.documentCollection) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.documents, this.sorts, this.documentCollection, this.condition);
    }

    public String toString() {
        return "DefaultDeleteQueryBuilder{documents=" + this.documents + ", sorts=" + this.sorts + ", documentCollection='" + this.documentCollection + "', condition=" + this.condition + "}";
    }
}

