/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import jakarta.data.repository.Sort;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.document.DocumentQuery;

class DefaultDocumentQuery
implements DocumentQuery {
    private final long limit;
    private final long skip;
    private final String documentCollection;
    private final DocumentCondition condition;
    private final List<Sort> sorts;
    private final List<String> documents;

    DefaultDocumentQuery(long limit, long skip, String documentCollection, List<String> documents, List<Sort> sorts, DocumentCondition condition) {
        this.limit = limit;
        this.skip = skip;
        this.documentCollection = documentCollection;
        this.condition = Optional.ofNullable(condition).map(DocumentCondition::readOnly).orElse(null);
        this.sorts = sorts;
        this.documents = documents;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public long skip() {
        return this.skip;
    }

    @Override
    public String name() {
        return this.documentCollection;
    }

    @Override
    public Optional<DocumentCondition> condition() {
        return Optional.ofNullable(this.condition);
    }

    @Override
    public List<Sort> sorts() {
        return Collections.unmodifiableList(this.sorts);
    }

    @Override
    public List<String> documents() {
        return Collections.unmodifiableList(this.documents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentQuery)) {
            return false;
        }
        DocumentQuery that = (DocumentQuery)o;
        return this.limit == that.limit() && this.skip == that.skip() && Objects.equals(this.documentCollection, that.name()) && Objects.equals(this.condition, that.condition().orElse(null)) && Objects.equals(this.sorts, that.sorts()) && Objects.equals(this.documents, that.documents());
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.skip, this.documentCollection, this.condition, this.sorts, this.documents);
    }

    public String toString() {
        return "DocumentQuery{maxResult=" + this.limit + ", firstResult=" + this.skip + ", documentCollection='" + this.documentCollection + "', condition=" + this.condition + ", sorts=" + this.sorts + ", documents=" + this.documents + "}";
    }

    static DocumentQuery countBy(DocumentQuery query) {
        return new DefaultDocumentQuery(0L, 0L, query.name(), query.documents(), Collections.emptyList(), query.condition().orElse(null));
    }

    static DocumentQuery existsBy(DocumentQuery query) {
        return new DefaultDocumentQuery(1L, 0L, query.name(), query.documents(), Collections.emptyList(), query.condition().orElse(null));
    }
}

