/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import jakarta.data.repository.Sort;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.DefaultDocumentQuery;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.communication.document.DocumentManager;
import org.eclipse.jnosql.communication.document.DocumentQuery;

class DefaultDocumentQueryBuilder
implements DocumentQuery.DocumentQueryBuilder {
    private final List<String> documents = new ArrayList<String>();
    private final List<Sort> sorts = new ArrayList<Sort>();
    private String documentCollection;
    private DocumentCondition condition;
    private long skip;
    private long limit;

    DefaultDocumentQueryBuilder() {
    }

    @Override
    public DocumentQuery.DocumentQueryBuilder select(String document) {
        Objects.requireNonNull(document, "document is required");
        this.documents.add(document);
        return this;
    }

    @Override
    public DocumentQuery.DocumentQueryBuilder select(String ... documents) {
        Consumer<String> validNull = d -> Objects.requireNonNull(d, "there is null document in the query");
        Consumer<String> consume = this.documents::add;
        Stream.of(documents).forEach(validNull.andThen(consume));
        return this;
    }

    @Override
    public DocumentQuery.DocumentQueryBuilder sort(Sort sort) {
        Objects.requireNonNull(sort, "sort is required");
        this.sorts.add(sort);
        return this;
    }

    @Override
    public DocumentQuery.DocumentQueryBuilder sort(Sort ... sorts) {
        Consumer<Sort> validNull = d -> Objects.requireNonNull(d, "there is null document in the query");
        Consumer<Sort> consume = this.sorts::add;
        Stream.of(sorts).forEach(validNull.andThen(consume));
        return this;
    }

    @Override
    public DocumentQuery.DocumentQueryBuilder from(String documentCollection) {
        Objects.requireNonNull(documentCollection, "documentCollection is required");
        this.documentCollection = documentCollection;
        return this;
    }

    @Override
    public DocumentQuery.DocumentQueryBuilder where(DocumentCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        this.condition = condition;
        return this;
    }

    @Override
    public DocumentQuery.DocumentQueryBuilder skip(long skip) {
        if (skip < 0L) {
            throw new IllegalArgumentException("The skip should not be negative, skip: " + skip);
        }
        this.skip = skip;
        return this;
    }

    @Override
    public DocumentQuery.DocumentQueryBuilder limit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("The limit should not be negative, limit: " + limit);
        }
        this.limit = limit;
        return this;
    }

    @Override
    public DocumentQuery build() {
        if (Objects.isNull(this.documentCollection)) {
            throw new IllegalArgumentException("The document collection is mandatory to build");
        }
        return new DefaultDocumentQuery(this.limit, this.skip, this.documentCollection, this.documents, this.sorts, this.condition);
    }

    @Override
    public Stream<DocumentEntity> getResult(DocumentManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.select(this.build());
    }

    @Override
    public Optional<DocumentEntity> getSingleResult(DocumentManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.singleResult(this.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDocumentQueryBuilder that = (DefaultDocumentQueryBuilder)o;
        return this.skip == that.skip && this.limit == that.limit && Objects.equals(this.documents, that.documents) && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.documentCollection, that.documentCollection) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.documents, this.sorts, this.documentCollection, this.condition, this.skip, this.limit);
    }

    public String toString() {
        return "DefaultDocumentQueryBuilder{documents=" + this.documents + ", sorts=" + this.sorts + ", documentCollection='" + this.documentCollection + "', condition=" + this.condition + ", skip=" + this.skip + ", limit=" + this.limit + "}";
    }
}

