/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.document.Document;

public final class DocumentCondition {
    private final Document document;
    private final Condition condition;
    private final boolean readOnly;

    private DocumentCondition(Document document, Condition condition) {
        this.document = document;
        this.condition = condition;
        this.readOnly = false;
    }

    private DocumentCondition(Document document, Condition condition, boolean readOnly) {
        this.document = document;
        this.condition = condition;
        this.readOnly = readOnly;
    }

    public Document document() {
        return this.document;
    }

    public Condition condition() {
        return this.condition;
    }

    public DocumentCondition and(DocumentCondition condition) {
        this.validateReadOnly();
        Objects.requireNonNull(condition, "Conditions is required");
        if (Condition.AND.equals((Object)this.condition)) {
            Document column = this.getConditions(condition, Condition.AND);
            return new DocumentCondition(column, Condition.AND);
        }
        return DocumentCondition.and(this, condition);
    }

    public DocumentCondition negate() {
        this.validateReadOnly();
        if (Condition.NOT.equals((Object)this.condition)) {
            return this.document.get(DocumentCondition.class);
        }
        Document newDocument = Document.of(Condition.NOT.getNameField(), this);
        return new DocumentCondition(newDocument, Condition.NOT);
    }

    public DocumentCondition or(DocumentCondition condition) {
        this.validateReadOnly();
        Objects.requireNonNull(condition, "Condition is required");
        if (Condition.OR.equals((Object)this.condition)) {
            Document newDocument = this.getConditions(condition, Condition.OR);
            return new DocumentCondition(newDocument, Condition.OR);
        }
        return DocumentCondition.or(this, condition);
    }

    private void validateReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("You cannot change the status after building the query");
        }
    }

    private Document getConditions(DocumentCondition columnCondition, Condition condition) {
        ArrayList<DocumentCondition> conditions = new ArrayList<DocumentCondition>((Collection)this.document.get(new TypeReference<List<DocumentCondition>>(){}));
        conditions.add(columnCondition);
        return Document.of(condition.getNameField(), conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentCondition that = (DocumentCondition)o;
        return Objects.equals(this.document, that.document) && this.condition == that.condition;
    }

    public int hashCode() {
        return Objects.hash(this.document, this.condition);
    }

    public String toString() {
        return "DocumentCondition{document=" + this.document + ", condition=" + this.condition + "}";
    }

    public static DocumentCondition readOnly(DocumentCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        return new DocumentCondition(condition.document(), condition.condition(), true);
    }

    public static DocumentCondition of(Document document, Condition condition) {
        return new DocumentCondition(Objects.requireNonNull(document, "Document is required"), condition);
    }

    public static DocumentCondition and(DocumentCondition ... conditions) {
        Objects.requireNonNull(conditions, "condition is required");
        Document document = Document.of(Condition.AND.getNameField(), Arrays.asList(conditions));
        return DocumentCondition.of(document, Condition.AND);
    }

    public static DocumentCondition or(DocumentCondition ... conditions) {
        Objects.requireNonNull(conditions, "condition is required");
        Document document = Document.of(Condition.OR.getNameField(), Arrays.asList(conditions));
        return DocumentCondition.of(document, Condition.OR);
    }

    public static DocumentCondition eq(Document document) {
        Objects.requireNonNull(document, "document is required");
        return new DocumentCondition(document, Condition.EQUALS);
    }

    public static DocumentCondition eq(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return new DocumentCondition(Document.of(name, value), Condition.EQUALS);
    }

    public static DocumentCondition gt(Document document) {
        Objects.requireNonNull(document, "document is required");
        return new DocumentCondition(document, Condition.GREATER_THAN);
    }

    public static DocumentCondition gt(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return DocumentCondition.gt(Document.of(name, value));
    }

    public static DocumentCondition gte(Document document) {
        Objects.requireNonNull(document, "document is required");
        return new DocumentCondition(document, Condition.GREATER_EQUALS_THAN);
    }

    public static DocumentCondition gte(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return DocumentCondition.gte(Document.of(name, value));
    }

    public static DocumentCondition lt(Document document) {
        Objects.requireNonNull(document, "document is required");
        return new DocumentCondition(document, Condition.LESSER_THAN);
    }

    public static DocumentCondition lt(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return DocumentCondition.lt(Document.of(name, value));
    }

    public static DocumentCondition lte(Document document) {
        Objects.requireNonNull(document, "document is required");
        return new DocumentCondition(document, Condition.LESSER_EQUALS_THAN);
    }

    public static DocumentCondition lte(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return DocumentCondition.lte(Document.of(name, value));
    }

    public static DocumentCondition in(Document document) {
        Objects.requireNonNull(document, "document is required");
        Value value = document.value();
        DocumentCondition.checkInClause(value);
        return new DocumentCondition(document, Condition.IN);
    }

    public static DocumentCondition in(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return DocumentCondition.in(Document.of(name, value));
    }

    public static DocumentCondition like(Document document) {
        Objects.requireNonNull(document, "document is required");
        return new DocumentCondition(document, Condition.LIKE);
    }

    public static DocumentCondition like(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return DocumentCondition.like(Document.of(name, value));
    }

    public static DocumentCondition between(Document document) {
        Objects.requireNonNull(document, "document is required");
        DocumentCondition.checkBetweenClause(document.get());
        return new DocumentCondition(document, Condition.BETWEEN);
    }

    public static DocumentCondition not(DocumentCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        return condition.negate();
    }

    public static DocumentCondition between(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        return DocumentCondition.between(Document.of(name, value));
    }

    private static void checkInClause(Value value) {
        if (!value.isInstanceOf(Iterable.class)) {
            throw new IllegalArgumentException("On DocumentCondition#in you must use an iterable instead of class: " + value.getClass().getName());
        }
    }

    private static void checkBetweenClause(Object value) {
        if (Iterable.class.isInstance(value)) {
            long count = (int)StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).count();
            if (count != 2L) {
                throw new IllegalArgumentException("On DocumentCondition#between you must use an iterable with two elements");
            }
        } else {
            throw new IllegalArgumentException("On DocumentCondition#between you must use an iterable with two elements instead of class: " + value.getClass().getName());
        }
    }
}

