/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.DefaultDocumentDeleteQueryBuilder;
import org.eclipse.jnosql.communication.document.DefaultFluentDeleteQueryBuilder;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.document.DocumentManager;

public interface DocumentDeleteQuery {
    public String name();

    public Optional<DocumentCondition> condition();

    public List<String> documents();

    public static DocumentDelete delete(String ... documents) {
        Stream.of(documents).forEach(d -> Objects.requireNonNull(d, "there is null document in the query"));
        return new DefaultFluentDeleteQueryBuilder(Arrays.asList(documents));
    }

    public static DocumentDelete delete() {
        return new DefaultFluentDeleteQueryBuilder(Collections.emptyList());
    }

    public static DocumentDeleteQueryBuilder builder(String ... documents) {
        Stream.of(documents).forEach(d -> Objects.requireNonNull(d, "there is null document in the query"));
        DefaultDocumentDeleteQueryBuilder builder = new DefaultDocumentDeleteQueryBuilder();
        Stream.of(documents).forEach(builder::delete);
        return builder;
    }

    public static DocumentDeleteQueryBuilder builder() {
        return new DefaultDocumentDeleteQueryBuilder();
    }

    public static interface DocumentDeleteQueryBuilder {
        public DocumentDeleteQueryBuilder delete(String var1);

        public DocumentDeleteQueryBuilder delete(String ... var1);

        public DocumentDeleteQueryBuilder from(String var1);

        public DocumentDeleteQueryBuilder where(DocumentCondition var1);

        public DocumentDeleteQuery build();

        public void delete(DocumentManager var1);
    }

    public static interface DocumentDeleteWhere
    extends DocumentDeleteQueryBuild {
        public DocumentDeleteNameCondition and(String var1);

        public DocumentDeleteNameCondition or(String var1);
    }

    public static interface DocumentDeleteQueryBuild {
        public DocumentDeleteQuery build();

        public void delete(DocumentManager var1);
    }

    public static interface DocumentDeleteNotCondition
    extends DocumentDeleteNameCondition {
    }

    public static interface DocumentDeleteNameCondition {
        public <T> DocumentDeleteWhere eq(T var1);

        public DocumentDeleteWhere like(String var1);

        public <T> DocumentDeleteWhere gt(T var1);

        public <T> DocumentDeleteWhere gte(T var1);

        public <T> DocumentDeleteWhere lt(T var1);

        public <T> DocumentDeleteWhere lte(T var1);

        public <T> DocumentDeleteWhere between(T var1, T var2);

        public <T> DocumentDeleteWhere in(Iterable<T> var1);

        public DocumentDeleteNotCondition not();
    }

    public static interface DocumentDeleteFrom
    extends DocumentDeleteQueryBuild {
        public DocumentDeleteNameCondition where(String var1);
    }

    public static interface DocumentDeleteProvider
    extends Function<String[], DocumentDelete>,
    Supplier<DocumentDelete> {
    }

    public static interface DocumentDelete {
        public DocumentDeleteFrom from(String var1);
    }
}

