/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jnosql.communication.Entry;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.document.Document;

public class DocumentEntity {
    private final Map<String, Document> documents = new HashMap<String, Document>();
    private final String name;

    DocumentEntity(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public boolean remove(String documentName) {
        Objects.requireNonNull(documentName, "documentName is required");
        return this.documents.remove(documentName) != null;
    }

    public List<Document> documents() {
        return this.documents.values().stream().collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public void add(Document document) {
        Objects.requireNonNull(document, "Document is required");
        this.documents.put(document.name(), document);
    }

    public void add(String documentName, Object value) {
        Objects.requireNonNull(documentName, "documentName is required");
        Objects.requireNonNull(value, "value is required");
        this.documents.put(documentName, Document.of(documentName, Value.of((Object)value)));
    }

    public void add(String documentName, Value value) {
        Objects.requireNonNull(documentName, "documentName is required");
        Objects.requireNonNull(value, "value is required");
        this.documents.put(documentName, Document.of(documentName, value));
    }

    public void addAll(Iterable<Document> documents) {
        Objects.requireNonNull(documents, "documents are required");
        documents.forEach(this::add);
    }

    public Optional<Document> find(String documentName) {
        Objects.requireNonNull(documentName, "documentName is required");
        Document document = this.documents.get(documentName);
        return Optional.ofNullable(document);
    }

    public <T> Optional<T> find(String documentName, Class<T> type) {
        Objects.requireNonNull(documentName, "documentName is required");
        Objects.requireNonNull(type, "type is required");
        return Optional.ofNullable(this.documents.get(documentName)).map(d -> d.get(type));
    }

    public <T> Optional<T> find(String documentName, TypeSupplier<T> type) {
        Objects.requireNonNull(documentName, "documentName is required");
        Objects.requireNonNull(type, "type is required");
        return Optional.ofNullable(this.documents.get(documentName)).map(d -> d.get(type));
    }

    public int size() {
        return this.documents.size();
    }

    public boolean isEmpty() {
        return this.documents.isEmpty();
    }

    public DocumentEntity copy() {
        DocumentEntity entity = new DocumentEntity(this.name);
        entity.documents.putAll(new HashMap<String, Document>(this.documents));
        return entity;
    }

    public void clear() {
        this.documents.clear();
    }

    public Set<String> getDocumentNames() {
        return Collections.unmodifiableSet(this.documents.keySet());
    }

    public Collection<Value> getValues() {
        return this.documents.values().stream().map(Entry::value).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public boolean contains(String documentName) {
        Objects.requireNonNull(documentName, "documentName is required");
        return this.documents.containsKey(documentName);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Document> entry : this.documents.entrySet()) {
            Document document = entry.getValue();
            map.put(entry.getKey(), this.convert(document.get()));
        }
        return Collections.unmodifiableMap(map);
    }

    private Object convert(Object value) {
        if (value instanceof Document) {
            Document column = (Document)Document.class.cast(value);
            return Collections.singletonMap(column.name(), this.convert(column.get()));
        }
        if (value instanceof Iterable) {
            ArrayList list = new ArrayList();
            ((Iterable)Iterable.class.cast(value)).forEach(e -> list.add(this.convert(e)));
            return list;
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentEntity)) {
            return false;
        }
        DocumentEntity that = (DocumentEntity)o;
        return Objects.equals(this.documents().stream().sorted(Comparator.comparing(Entry::name)).collect(Collectors.toList()), that.documents().stream().sorted(Comparator.comparing(Entry::name)).collect(Collectors.toList())) && Objects.equals(this.name, that.name());
    }

    public int hashCode() {
        return Objects.hash(this.documents, this.name);
    }

    public String toString() {
        return "DefaultDocumentEntity{documents=" + this.documents + ", name='" + this.name + "'}";
    }

    public static DocumentEntity of(String name) {
        return new DocumentEntity(Objects.requireNonNull(name, "name is required"));
    }

    public static DocumentEntity of(String name, List<Document> documents) {
        Objects.requireNonNull(documents, "documents is required");
        DocumentEntity entity = new DocumentEntity(Objects.requireNonNull(name, "name is required"));
        entity.addAll(documents);
        return entity;
    }
}

