/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import jakarta.data.exceptions.NonUniqueResultException;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.DefaultDocumentQuery;
import org.eclipse.jnosql.communication.document.DocumentDeleteQuery;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.communication.document.DocumentObserverParser;
import org.eclipse.jnosql.communication.document.DocumentPreparedStatement;
import org.eclipse.jnosql.communication.document.DocumentQuery;
import org.eclipse.jnosql.communication.document.DocumentQueryParser;

public interface DocumentManager
extends AutoCloseable {
    public String name();

    public DocumentEntity insert(DocumentEntity var1);

    public DocumentEntity insert(DocumentEntity var1, Duration var2);

    public Iterable<DocumentEntity> insert(Iterable<DocumentEntity> var1);

    public Iterable<DocumentEntity> insert(Iterable<DocumentEntity> var1, Duration var2);

    public DocumentEntity update(DocumentEntity var1);

    public Iterable<DocumentEntity> update(Iterable<DocumentEntity> var1);

    public void delete(DocumentDeleteQuery var1);

    public Stream<DocumentEntity> select(DocumentQuery var1);

    default public long count(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        return this.select(DefaultDocumentQuery.countBy(query)).count();
    }

    default public boolean exists(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        return this.select(DefaultDocumentQuery.existsBy(query)).findAny().isPresent();
    }

    default public Stream<DocumentEntity> query(String query) {
        Objects.requireNonNull(query, "query is required");
        DocumentQueryParser parser = new DocumentQueryParser();
        return parser.query(query, this, DocumentObserverParser.EMPTY);
    }

    default public DocumentPreparedStatement prepare(String query) {
        Objects.requireNonNull(query, "query is required");
        DocumentQueryParser parser = new DocumentQueryParser();
        return parser.prepare(query, this, DocumentObserverParser.EMPTY);
    }

    default public Optional<DocumentEntity> singleResult(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        Stream<DocumentEntity> entities = this.select(query);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        DocumentEntity entity = (DocumentEntity)iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + query);
    }

    public long count(String var1);

    @Override
    public void close();
}

