/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import jakarta.data.repository.Sort;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.DefaultDocumentQueryBuilder;
import org.eclipse.jnosql.communication.document.DefaultFluentDocumentQueryBuilder;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.communication.document.DocumentManager;

public interface DocumentQuery {
    public long limit();

    public long skip();

    public String name();

    public Optional<DocumentCondition> condition();

    public List<Sort> sorts();

    public List<String> documents();

    public static DocumentSelect select(String ... documents) {
        Stream.of(documents).forEach(d -> Objects.requireNonNull(d, "there is null document in the query"));
        return new DefaultFluentDocumentQueryBuilder(Arrays.asList(documents));
    }

    public static DocumentSelect select() {
        return new DefaultFluentDocumentQueryBuilder(Collections.emptyList());
    }

    public static DocumentQueryBuilder builder() {
        return new DefaultDocumentQueryBuilder();
    }

    public static DocumentQueryBuilder builder(String ... documents) {
        Stream.of(documents).forEach(d -> Objects.requireNonNull(d, "there is null document in the query"));
        DefaultDocumentQueryBuilder builder = new DefaultDocumentQueryBuilder();
        Stream.of(documents).forEach(builder::select);
        return builder;
    }

    public static interface DocumentQueryBuilder {
        public DocumentQueryBuilder select(String var1);

        public DocumentQueryBuilder select(String ... var1);

        public DocumentQueryBuilder sort(Sort var1);

        public DocumentQueryBuilder sort(Sort ... var1);

        public DocumentQueryBuilder from(String var1);

        public DocumentQueryBuilder where(DocumentCondition var1);

        public DocumentQueryBuilder skip(long var1);

        public DocumentQueryBuilder limit(long var1);

        public DocumentQuery build();

        public Stream<DocumentEntity> getResult(DocumentManager var1);

        public Optional<DocumentEntity> getSingleResult(DocumentManager var1);
    }

    public static interface DocumentQueryBuild {
        public DocumentQuery build();

        public Stream<DocumentEntity> getResult(DocumentManager var1);

        public Optional<DocumentEntity> getSingleResult(DocumentManager var1);
    }

    public static interface DocumentOrder {
        public DocumentNameOrder asc();

        public DocumentNameOrder desc();
    }

    public static interface DocumentWhere
    extends DocumentQueryBuild {
        public DocumentNameCondition and(String var1);

        public DocumentNameCondition or(String var1);

        public DocumentSkip skip(long var1);

        public DocumentLimit limit(long var1);

        public DocumentOrder orderBy(String var1);
    }

    public static interface DocumentSkip
    extends DocumentQueryBuild {
        public DocumentLimit limit(long var1);
    }

    public static interface DocumentSelect {
        public DocumentFrom from(String var1);
    }

    public static interface DocumentNotCondition
    extends DocumentNameCondition {
    }

    public static interface DocumentNameOrder
    extends DocumentQueryBuild {
        public DocumentOrder orderBy(String var1);

        public DocumentSkip skip(long var1);

        public DocumentLimit limit(long var1);
    }

    public static interface DocumentNameCondition {
        public <T> DocumentWhere eq(T var1);

        public DocumentWhere like(String var1);

        public <T> DocumentWhere gt(T var1);

        public <T> DocumentWhere gte(T var1);

        public <T> DocumentWhere lt(T var1);

        public <T> DocumentWhere lte(T var1);

        public <T> DocumentWhere between(T var1, T var2);

        public <T> DocumentWhere in(Iterable<T> var1);

        public DocumentNotCondition not();
    }

    public static interface DocumentLimit
    extends DocumentQueryBuild {
        public DocumentSkip skip(long var1);
    }

    public static interface DocumentQueryBuilderProvider
    extends Function<String[], DocumentQueryBuilder>,
    Supplier<DocumentQueryBuilder> {
    }

    public static interface DocumentSelectProvider
    extends Function<String[], DocumentSelect>,
    Supplier<DocumentSelect> {
    }

    public static interface DocumentFrom
    extends DocumentQueryBuild {
        public DocumentNameCondition where(String var1);

        public DocumentSkip skip(long var1);

        public DocumentLimit limit(long var1);

        public DocumentOrder orderBy(String var1);
    }
}

