/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.document.DeleteQueryParser;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.communication.document.DocumentManager;
import org.eclipse.jnosql.communication.document.DocumentObserverParser;
import org.eclipse.jnosql.communication.document.DocumentPreparedStatement;
import org.eclipse.jnosql.communication.document.InsertQueryParser;
import org.eclipse.jnosql.communication.document.SelectQueryParser;
import org.eclipse.jnosql.communication.document.UpdateQueryParser;

public final class DocumentQueryParser {
    private final SelectQueryParser select = new SelectQueryParser();
    private final DeleteQueryParser delete = new DeleteQueryParser();
    private final InsertQueryParser insert = new InsertQueryParser();
    private final UpdateQueryParser update = new UpdateQueryParser();

    public Stream<DocumentEntity> query(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        String command;
        this.validation(query, collectionManager, observer);
        return switch (command = query.substring(0, 6)) {
            case "select" -> this.select.query(query, collectionManager, observer);
            case "delete" -> this.delete.query(query, collectionManager, observer);
            case "insert" -> this.insert.query(query, collectionManager, observer);
            case "update" -> this.update.query(query, collectionManager, observer);
            default -> throw new QueryException(String.format("The command was not recognized at the query %s ", query));
        };
    }

    public DocumentPreparedStatement prepare(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        String command;
        this.validation(query, collectionManager, observer);
        return switch (command = query.substring(0, 6)) {
            case "select" -> this.select.prepare(query, collectionManager, observer);
            case "delete" -> this.delete.prepare(query, collectionManager, observer);
            case "insert" -> this.insert.prepare(query, collectionManager, observer);
            case "update" -> this.update.prepare(query, collectionManager, observer);
            default -> throw new QueryException(String.format("The command was not recognized at the query %s ", query));
        };
    }

    private void validation(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(collectionManager, "collectionManager is required");
        Objects.requireNonNull(observer, "observer is required");
        if (query.length() < 6) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }
}

