/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.document.Document;

public final class Documents {
    private static final Predicate<Map.Entry<String, ?>> IS_VALUE_NULL = e -> Objects.nonNull(e.getValue());

    private Documents() {
    }

    public static Document of(String name, Object value) {
        return Document.of(name, Value.of((Object)value));
    }

    public static List<Document> of(Map<String, ?> values) {
        Objects.requireNonNull(values, "values is required");
        return values.entrySet().stream().filter(IS_VALUE_NULL).map(e -> Document.of((String)e.getKey(), Documents.getValue(e.getValue()))).collect(Collectors.toList());
    }

    private static Object getValue(Object value) {
        if (value instanceof Map) {
            List<Document> list = Documents.of((Map)Map.class.cast(value));
            if (list.size() == 1) {
                return list.get(0);
            }
            return list;
        }
        if (value instanceof Iterable) {
            return StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).map(Documents::getValue).collect(Collectors.toList());
        }
        return value;
    }
}

