/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.document.ConditionQueryParser;
import org.eclipse.jnosql.communication.document.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.communication.document.DocumentManager;
import org.eclipse.jnosql.communication.document.DocumentObserverParser;
import org.eclipse.jnosql.communication.document.DocumentPreparedStatement;
import org.eclipse.jnosql.communication.query.InsertQuery;
import org.eclipse.jnosql.communication.query.InsertQueryConverter;
import org.eclipse.jnosql.communication.query.JSONQueryValue;
import org.eclipse.jnosql.communication.query.QueryCondition;

final class InsertQueryParser
extends ConditionQueryParser {
    InsertQueryParser() {
    }

    Stream<DocumentEntity> query(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        InsertQueryConverter converter = new InsertQueryConverter();
        InsertQuery insertQuery = converter.apply(query);
        String collection = insertQuery.entity();
        Params params = Params.newParams();
        DocumentEntity entity = this.getEntity(insertQuery, collection, params, observer);
        Optional ttl = insertQuery.ttl();
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return ttl.map(duration -> Stream.of(collectionManager.insert(entity, (Duration)duration))).orElseGet(() -> Stream.of(collectionManager.insert(entity)));
    }

    DocumentPreparedStatement prepare(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        InsertQueryConverter converter = new InsertQueryConverter();
        InsertQuery insertQuery = converter.apply(query);
        String collection = observer.fireEntity(insertQuery.entity());
        Params params = Params.newParams();
        Optional ttl = insertQuery.ttl();
        DocumentEntity entity = this.getEntity(insertQuery, collection, params, observer);
        return DocumentPreparedStatement.insert(entity, params, query, ttl.orElse(null), collectionManager);
    }

    private DocumentEntity getEntity(InsertQuery insertQuery, String collection, Params params, DocumentObserverParser observer) {
        return this.getEntity(new InsertQueryConditionSupplier(insertQuery), collection, params, observer);
    }

    private record InsertQueryConditionSupplier(InsertQuery query) implements ConditionQuerySupplier
    {
        @Override
        public List<QueryCondition> conditions() {
            return this.query.conditions();
        }

        @Override
        public Optional<JSONQueryValue> value() {
            return this.query.value();
        }
    }
}

