/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import jakarta.data.repository.Direction;
import jakarta.data.repository.Sort;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.document.Conditions;
import org.eclipse.jnosql.communication.document.DefaultDocumentQuery;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.communication.document.DocumentManager;
import org.eclipse.jnosql.communication.document.DocumentObserverParser;
import org.eclipse.jnosql.communication.document.DocumentPreparedStatement;
import org.eclipse.jnosql.communication.document.DocumentQuery;
import org.eclipse.jnosql.communication.document.DocumentQueryParams;
import org.eclipse.jnosql.communication.query.DefaultSelectQuery;
import org.eclipse.jnosql.communication.query.SelectQuery;
import org.eclipse.jnosql.communication.query.SelectQueryConverter;

public final class SelectQueryParser
implements BiFunction<SelectQuery, DocumentObserverParser, DocumentQueryParams> {
    Stream<DocumentEntity> query(String query, DocumentManager manager, DocumentObserverParser observer) {
        DocumentQuery documentQuery = this.getDocumentQuery(query, observer);
        return manager.select(documentQuery);
    }

    DocumentPreparedStatement prepare(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        Params params = Params.newParams();
        SelectQueryConverter converter = new SelectQueryConverter();
        DefaultSelectQuery selectQuery = converter.apply(query);
        DocumentQuery documentQuery = this.getDocumentQuery(params, (SelectQuery)selectQuery, observer);
        return DocumentPreparedStatement.select(documentQuery, params, query, collectionManager);
    }

    @Override
    public DocumentQueryParams apply(SelectQuery selectQuery, DocumentObserverParser observer) {
        Objects.requireNonNull(selectQuery, "selectQuery is required");
        Objects.requireNonNull(observer, "observer is required");
        Params params = Params.newParams();
        DocumentQuery columnQuery = this.getDocumentQuery(params, selectQuery, observer);
        return new DocumentQueryParams(columnQuery, params);
    }

    private DocumentQuery getDocumentQuery(String query, DocumentObserverParser observer) {
        SelectQueryConverter converter = new SelectQueryConverter();
        DefaultSelectQuery selectQuery = converter.apply(query);
        String collection = observer.fireEntity(selectQuery.entity());
        long limit = selectQuery.limit();
        long skip = selectQuery.skip();
        List<String> documents = selectQuery.fields().stream().map(f -> observer.fireField(collection, (String)f)).collect(Collectors.toList());
        List<Sort> sorts = selectQuery.orderBy().stream().map(s -> this.toSort((Sort)s, observer, collection)).collect(Collectors.toList());
        Params params = Params.newParams();
        DocumentCondition condition = selectQuery.where().map(c -> Conditions.getCondition(c, params, observer, collection)).orElse(null);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultDocumentQuery(limit, skip, collection, documents, sorts, condition);
    }

    private DocumentQuery getDocumentQuery(Params params, SelectQuery selectQuery, DocumentObserverParser observer) {
        String collection = observer.fireEntity(selectQuery.entity());
        long limit = selectQuery.limit();
        long skip = selectQuery.skip();
        List<String> documents = selectQuery.fields().stream().map(f -> observer.fireField(collection, (String)f)).collect(Collectors.toList());
        List<Sort> sorts = selectQuery.orderBy().stream().map(s -> this.toSort((Sort)s, observer, collection)).collect(Collectors.toList());
        DocumentCondition condition = selectQuery.where().map(c -> Conditions.getCondition(c, params, observer, collection)).orElse(null);
        return new DefaultDocumentQuery(limit, skip, collection, documents, sorts, condition);
    }

    private Sort toSort(Sort sort, DocumentObserverParser observer, String entity) {
        return Sort.of((String)observer.fireField(entity, sort.property()), (Direction)(sort.isAscending() ? Direction.ASC : Direction.DESC), (boolean)false);
    }
}

