/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.document.ConditionQueryParser;
import org.eclipse.jnosql.communication.document.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.communication.document.DocumentManager;
import org.eclipse.jnosql.communication.document.DocumentObserverParser;
import org.eclipse.jnosql.communication.document.DocumentPreparedStatement;
import org.eclipse.jnosql.communication.query.JSONQueryValue;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.query.UpdateQuery;
import org.eclipse.jnosql.communication.query.UpdateQueryConverter;

final class UpdateQueryParser
extends ConditionQueryParser {
    UpdateQueryParser() {
    }

    Stream<DocumentEntity> query(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        UpdateQueryConverter converter = new UpdateQueryConverter();
        UpdateQuery updateQuery = converter.apply(query);
        Params params = Params.newParams();
        DocumentEntity entity = this.getEntity(params, updateQuery, observer);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return Stream.of(collectionManager.update(entity));
    }

    DocumentPreparedStatement prepare(String query, DocumentManager collectionManager, DocumentObserverParser observer) {
        Params params = Params.newParams();
        UpdateQueryConverter converter = new UpdateQueryConverter();
        UpdateQuery updateQuery = converter.apply(query);
        DocumentEntity entity = this.getEntity(params, updateQuery, observer);
        return DocumentPreparedStatement.update(entity, params, query, collectionManager);
    }

    private DocumentEntity getEntity(Params params, UpdateQuery updateQuery, DocumentObserverParser observer) {
        String collection = observer.fireEntity(updateQuery.entity());
        return this.getEntity(new UpdateQueryConditioinSupplier(updateQuery), collection, params, observer);
    }

    private record UpdateQueryConditioinSupplier(UpdateQuery query) implements ConditionQuerySupplier
    {
        @Override
        public List<QueryCondition> conditions() {
            return this.query.conditions();
        }

        @Override
        public Optional<JSONQueryValue> value() {
            return this.query.value();
        }
    }
}

