/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.document;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.document.JsonObjects;
import org.eclipse.jnosql.communication.query.ArrayQueryValue;
import org.eclipse.jnosql.communication.query.Function;
import org.eclipse.jnosql.communication.query.FunctionQueryValue;
import org.eclipse.jnosql.communication.query.JSONQueryValue;
import org.eclipse.jnosql.communication.query.ParamQueryValue;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.ValueType;

final class Values {
    private Values() {
    }

    static Object get(QueryValue<?> value, Params parameters) {
        ValueType type = value.type();
        switch (type) {
            case NUMBER: 
            case STRING: 
            case BOOLEAN: {
                return value.get();
            }
            case PARAMETER: {
                return parameters.add((String)((ParamQueryValue)ParamQueryValue.class.cast(value)).get());
            }
            case ARRAY: {
                return Stream.of((QueryValue[])((ArrayQueryValue)ArrayQueryValue.class.cast(value)).get()).map(v -> Values.get(v, parameters)).collect(Collectors.toList());
            }
            case FUNCTION: {
                Function function = ((FunctionQueryValue)FunctionQueryValue.class.cast(value)).get();
                String name = function.name();
                Object[] params = function.params();
                if ("convert".equals(name)) {
                    return Value.of((Object)Values.get((QueryValue)QueryValue.class.cast(params[0]), parameters)).get((Class)params[1]);
                }
                String message = String.format("There is not support to the function: %s with parameters %s", name, Arrays.toString(params));
                throw new QueryException(message);
            }
            case JSON: {
                return JsonObjects.getDocuments(((JSONQueryValue)JSONQueryValue.class.cast(value)).get());
            }
        }
        throw new QueryException("There is not support to the value: " + type);
    }
}

