/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.driver;

import jakarta.nosql.Value;
import jakarta.nosql.ValueWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.writer.ValueWriterDecorator;

public final class ValueUtil {
    private static final String PARAM_CLASS_NAME = "org.eclipse.jnosql.communication.ParamValue";
    private static final ValueWriter VALUE_WRITER = ValueWriterDecorator.getInstance();
    private static final Function CONVERT = o -> {
        if (o instanceof Value) {
            return ValueUtil.convert((Value)Value.class.cast(o));
        }
        return ValueUtil.getObject(o);
    };

    private ValueUtil() {
    }

    public static Object convert(Value value) {
        Objects.requireNonNull(value, "value is required");
        Object val = value.get();
        if (val instanceof Iterable) {
            return ValueUtil.getObjects(val);
        }
        return ValueUtil.getObject(val);
    }

    public static List<Object> convertToList(Value value) {
        Objects.requireNonNull(value, "value is required");
        Object val = value.get();
        if (val instanceof Iterable) {
            Object item;
            ArrayList items = new ArrayList();
            ((Iterable)Iterable.class.cast(val)).forEach(items::add);
            if (items.size() == 1 && PARAM_CLASS_NAME.equals((item = items.get(0)).getClass().getName())) {
                Object params = ((Value)Value.class.cast(item)).get();
                if (params instanceof Iterable) {
                    return ValueUtil.getObjects(Iterable.class.cast(params));
                }
                return Collections.singletonList(ValueUtil.getObject(params));
            }
            return items.stream().map(CONVERT).collect(Collectors.toList());
        }
        return Collections.singletonList(ValueUtil.getObject(val));
    }

    private static List<Object> getObjects(Object val) {
        return StreamSupport.stream(((Iterable)Iterable.class.cast(val)).spliterator(), false).map(CONVERT).collect(Collectors.toList());
    }

    private static Object getObject(Object val) {
        if (VALUE_WRITER.test(val.getClass())) {
            return VALUE_WRITER.write(val);
        }
        return val;
    }
}

