/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.driver.attachment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.jnosql.communication.driver.attachment.ByteArrayEntityAttachment;
import org.eclipse.jnosql.communication.driver.attachment.PathEntityAttachment;

public interface EntityAttachment {
    public String getName();

    public long getLastModified();

    public String getContentType();

    public InputStream getData() throws IOException;

    public long getLength();

    default public String getETag() {
        return this.getName() + "-" + Long.toString(this.getLastModified(), 16);
    }

    public static EntityAttachment of(String name, long lastModified, String contentType, byte[] data) {
        return new ByteArrayEntityAttachment(name, contentType, lastModified, data);
    }

    public static EntityAttachment of(Path path) {
        return new PathEntityAttachment(path);
    }

    public static EntityAttachment of(File file) {
        Objects.requireNonNull(file, "file cannot be null");
        return EntityAttachment.of(file.toPath());
    }
}

