/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.keyvalue;

import jakarta.nosql.TypeSupplier;
import jakarta.nosql.Value;
import jakarta.nosql.keyvalue.KeyValueEntity;
import java.util.Objects;

final class DefaultKeyValueEntity
implements KeyValueEntity {
    private final Object key;
    private final Value value;

    DefaultKeyValueEntity(Object key, Value value) {
        this.key = key;
        this.value = value;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value.get();
    }

    public <K> K getKey(TypeSupplier<K> supplier) {
        Objects.requireNonNull(supplier, "supplier is required");
        return (K)Value.of((Object)this.key).get(supplier);
    }

    public <K> K getKey(Class<K> type) {
        Objects.requireNonNull(type, "type is required");
        return (K)Value.of((Object)this.key).get(type);
    }

    public <V> V getValue(TypeSupplier<V> supplier) {
        Objects.requireNonNull(supplier, "supplier is required");
        return (V)this.value.get(supplier);
    }

    public <V> V getValue(Class<V> type) {
        Objects.requireNonNull(type, "type is required");
        return (V)this.value.get(type);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultKeyValueEntity that = (DefaultKeyValueEntity)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public String toString() {
        return "DefaultKeyValueEntity{key=" + this.key + ", value=" + this.value + "}";
    }
}

